/*
 * Decompiled with CFR 0.152.
 */
package jmaster.util.system;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.regex.Pattern;
import jmaster.util.log.A;
import jmaster.util.log.B;
import jmaster.util.property.C;
import jmaster.util.property.D;

public class SystemHelper {
    public static final String PROPERTY_FILE_NAME = "SystemHelper.properties";
    public static final String PREFIX = "systemHelper";
    private static final int B = -1;
    private static final int C = 0;
    private static final int A = 1;
    private static final int H = 2;
    private static SystemHelper K;
    protected A E = jmaster.util.log.B.getInstance().getLog(this.getClass());
    protected int D;
    protected String J;
    protected String F;
    protected String G;
    protected String I;

    protected SystemHelper() {
        D d2 = jmaster.util.property.B.C().G(PROPERTY_FILE_NAME);
        C c2 = jmaster.util.property.C.A();
        c2.A((Object)this, d2, PREFIX);
        try {
            String string = System.getProperty("os.name");
            if (string == null) {
                throw new IOException("os.name not found");
            }
            this.D = (string = string.toLowerCase(Locale.ENGLISH)).indexOf("windows") != -1 ? 1 : (string.indexOf("linux") != -1 || string.indexOf("sun os") != -1 || string.indexOf("sunos") != -1 || string.indexOf("solaris") != -1 || string.indexOf("mpe/ix") != -1 || string.indexOf("hp-ux") != -1 || string.indexOf("aix") != -1 || string.indexOf("freebsd") != -1 || string.indexOf("irix") != -1 || string.indexOf("digital unix") != -1 || string.indexOf("unix") != -1 || string.indexOf("mac os x") != -1 ? 2 : 0);
        }
        catch (Exception exception) {
            this.D = -1;
        }
    }

    public static synchronized SystemHelper getInstance() {
        if (K == null) {
            K = new SystemHelper();
        }
        return K;
    }

    public String getOpenFileWindowsCmd() {
        return this.J;
    }

    public void setOpenFileWindowsCmd(String string) {
        this.J = string;
    }

    public String getOpenFolderWindowsCmd() {
        return this.F;
    }

    public void setOpenFolderWindowsCmd(String string) {
        this.F = string;
    }

    public String getOpenFileUnixCmd() {
        return this.G;
    }

    public void setOpenFileUnixCmd(String string) {
        this.G = string;
    }

    public String getOpenFolderUnixCmd() {
        return this.I;
    }

    public void setOpenFolderUnixCmd(String string) {
        this.I = string;
    }

    public int executeProcessAndWait(String ... stringArray) {
        Process process = this.executeProcess(stringArray);
        if (process == null) {
            throw new RuntimeException("Failed to create process: " + stringArray);
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return process.exitValue();
    }

    public Process executeProcess(String ... stringArray) {
        Process process = null;
        StringBuilder stringBuilder = new StringBuilder("");
        for (String string : stringArray) {
            stringBuilder.append(" arg:" + string);
        }
        if (this.E.B()) {
            this.E.D("SystemHelper.executeProcess(" + stringBuilder + ")");
        }
        try {
            process = Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            this.E.E("SystemHelper.executeProcess(" + stringBuilder + ") failed", exception);
        }
        return process;
    }

    private String[] A(String string, String string2) throws Exception {
        String[] stringArray;
        String string3 = string;
        File file = null;
        URL uRL = null;
        try {
            uRL = new URL(string2);
        }
        catch (Exception exception) {
            file = new File(string2);
            uRL = file.toURI().toURL();
        }
        String string4 = uRL.toExternalForm();
        if (string4.toLowerCase().startsWith("file:/") && !string4.toLowerCase().startsWith("file:///")) {
            string4 = "file:///" + string4.substring("file:/".length());
        }
        string4 = string4.replaceAll("\\\\", "\\\\\\\\");
        string3 = string3.replaceAll("\\$\\{fileUrl\\}", string4);
        if (file != null) {
            stringArray = file.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\");
            string3 = string3.replaceAll("\\$\\{filePath\\}", (String)stringArray);
        }
        stringArray = string3.split(Pattern.quote("{|}"));
        return stringArray;
    }

    private Process B(String string) {
        Process process = null;
        try {
            String[] stringArray = this.A(this.J, string);
            process = this.executeProcess(stringArray);
        }
        catch (Exception exception) {
            this.E.E("openFileWindows( " + string + " ) failed", exception);
        }
        return process;
    }

    private Process A(String string) {
        Process process = null;
        try {
            String[] stringArray = this.A(this.F, string);
            process = this.executeProcess(stringArray);
        }
        catch (Exception exception) {
            this.E.E("openFolderWindowsCmd( " + string + " ) failed", exception);
        }
        return process;
    }

    private Process D(String string) {
        Process process = null;
        try {
            String[] stringArray = this.A(this.G, string);
            process = this.executeProcess(stringArray);
        }
        catch (Exception exception) {
            this.E.E("openFileUnix( " + string + " ) failed", exception);
        }
        return process;
    }

    private Process C(String string) {
        Process process = null;
        try {
            String[] stringArray = this.A(this.I, string);
            process = this.executeProcess(stringArray);
        }
        catch (Exception exception) {
            this.E.E("openFolderUnixCmd( " + string + " ) failed", exception);
        }
        return process;
    }

    public Process openFile(String string) {
        Process process = null;
        switch (this.D) {
            case 1: {
                process = this.B(string);
                break;
            }
            case 2: {
                process = this.D(string);
                break;
            }
            default: {
                this.E.C("openFile() not implemented for OS: " + this.D);
            }
        }
        return process;
    }

    public Process openFolder(String string) {
        Process process = null;
        switch (this.D) {
            case 1: {
                process = this.A(string);
                break;
            }
            case 2: {
                process = this.C(string);
                break;
            }
            default: {
                this.E.C("openFolder() not implemented for OS: " + this.D);
            }
        }
        return process;
    }

    public long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public boolean isWindows() {
        return 1 == this.D;
    }
}

