/*
 * Decompiled with CFR 0.152.
 */
package jmaster.util.lang.process.impl;

import java.util.Date;
import jmaster.util.lang.CodeException;
import jmaster.util.lang.LangHelper;
import jmaster.util.lang.bean.impl.GenericBean;
import jmaster.util.lang.process.IProcess;
import jmaster.util.lang.value.IValueProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericProcess
extends GenericBean
implements IProcess {
    private String \u0259 = "ready";
    private String \u0252;
    protected String \u025e;
    protected String \u0254;
    protected boolean \u0253 = false;
    protected boolean \u0258 = false;
    protected boolean \u025a = false;
    protected boolean \u025c = false;
    protected boolean \u0260 = false;
    protected Object \u0261;
    protected Runnable \u025f;
    protected Exception \u025d;
    protected float \u0256 = -1.0f;
    protected IValueProvider<Float> \u0255;
    protected Date \u0257;
    protected Date \u025b;

    @Override
    public boolean isCancellable() {
        return this.\u0258;
    }

    public void setCancellable(boolean bl) {
        this.\u0258 = bl;
    }

    @Override
    public boolean isPausable() {
        return this.\u025a;
    }

    public void setPausable(boolean bl) {
        this.\u025a = bl;
    }

    @Override
    public boolean isCancelled() {
        return this.\u025c;
    }

    public void setCancelled(boolean bl) {
        this.\u025c = bl;
    }

    @Override
    public Exception getError() {
        return this.\u025d;
    }

    public void setError(Exception exception) {
        this.\u025d = exception;
    }

    @Override
    public String getId() {
        return this.\u0252;
    }

    public void setId(String string) {
        this.\u0252 = string;
    }

    @Override
    public String getDescription() {
        return this.\u025e;
    }

    public void setDescription(String string) {
        this.\u025e = string;
    }

    @Override
    public float getCompletion() {
        return this.\u0255 == null ? this.\u0256 : this.\u0255.getValue().floatValue();
    }

    public void setCompletion(float f2) {
        this.\u0256 = f2;
    }

    @Override
    public String getStatus() {
        return this.\u0259;
    }

    @Override
    public boolean isRestartable() {
        return this.\u0253;
    }

    public void setRestartable(boolean bl) {
        this.\u0253 = bl;
    }

    @Override
    public String getTaskDescription() {
        return this.\u0254;
    }

    public void setTaskDescription(String string) {
        this.\u0254 = string;
    }

    public IValueProvider<Float> getCompletionValueProvider() {
        return this.\u0255;
    }

    public void setCompletionValueProvider(IValueProvider<Float> iValueProvider) {
        this.\u0255 = iValueProvider;
    }

    public Runnable getCancelCallback() {
        return this.\u025f;
    }

    public void setCancelCallback(Runnable runnable) {
        this.\u025f = runnable;
    }

    public void updateStatus(String string) {
        if (!LangHelper.equals(this.\u0259, string)) {
            this.\u0259 = string;
            this.C(EVENT_PROCESS_STATUS_CHANGED, this);
        }
    }

    @Override
    public boolean canCancel() {
        return this.\u0258 && (this.isRunning() || this.isPaused());
    }

    @Override
    public boolean canPause() {
        return this.\u025a && this.isRunning();
    }

    @Override
    public boolean canResume() {
        return this.isPaused();
    }

    @Override
    public boolean isPaused() {
        return "paused".equals(this.\u0259);
    }

    @Override
    public boolean isReady() {
        return "ready".equals(this.\u0259);
    }

    @Override
    public boolean isRunning() {
        return "running".equals(this.\u0259);
    }

    @Override
    public boolean isTerminated() {
        return "terminated".equals(this.\u0259);
    }

    @Override
    public boolean canRun() {
        return "ready".equals(this.\u0259);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object run() {
        if (!this.canRun()) {
            LangHelper.throwRuntime("Unable to start " + this);
        }
        try {
            this.start();
            this.\u0261 = this.\u00ca();
            this.\u025b = new Date();
            this.updateStatus(this.\u0253 ? "ready" : "terminated");
        }
        catch (Exception exception) {
            try {
                this.\u025d = exception;
                this.\u025b = new Date();
                this.updateStatus(this.\u0253 ? "ready" : "terminated");
            }
            catch (Throwable throwable) {
                this.\u025b = new Date();
                this.updateStatus(this.\u0253 ? "ready" : "terminated");
                throw throwable;
            }
        }
        return this.\u0261;
    }

    public void start() throws Exception {
        this.\u0256 = -1.0f;
        this.\u025d = null;
        this.\u0257 = new Date();
        this.\u025b = null;
        this.\u025c = false;
        this.\u0260 = false;
        this.\u00ce();
        this.updateStatus("running");
    }

    public void stop() {
        this.\u025b = new Date();
        this.updateStatus("terminated");
    }

    @Override
    public final void pause() {
        if (!this.canPause()) {
            LangHelper.throwRuntime("Unable to pause " + this);
        }
        this.\u0260 = true;
        this.\u00cb();
        this.updateStatus("paused");
    }

    @Override
    public final void resume() {
        if (!this.canResume()) {
            LangHelper.throwRuntime("Unable to resume " + this);
        }
        this.\u0260 = false;
        this.\u00cc();
        this.updateStatus("running");
    }

    @Override
    public final void cancel() {
        if (!this.canCancel()) {
            LangHelper.throwRuntime("Unable to cancel " + this);
        }
        this.\u025c = true;
        if (this.\u025f != null) {
            this.\u025f.run();
        }
        this.\u00cd();
        this.updateStatus(this.\u0253 ? "ready" : "terminated");
    }

    protected void \u00ce() throws Exception {
    }

    protected Object \u00ca() throws Exception {
        while (this.isRunning() || this.isPaused()) {
            Thread.sleep(100L);
        }
        return null;
    }

    protected void \u00cb() {
    }

    protected void \u00cc() {
    }

    protected void \u00cd() {
    }

    @Override
    public long getElapsedTime() {
        return this.isRunning() || this.isPaused() ? System.currentTimeMillis() - this.\u0257.getTime() : -1L;
    }

    @Override
    public long getEstimatedTimeLeft() {
        return this.isRunning() ? this.\u00cf() : -1L;
    }

    protected long \u00cf() {
        long l2 = -1L;
        if (this.\u0256 >= 0.0f) {
            l2 = this.\u0256 == 1.0f ? 0L : (long)((float)this.getElapsedTime() * (1.0f - this.\u0256) / this.\u0256);
        }
        return l2;
    }

    @Override
    public void destroy() {
        if (this.isRunning() || this.isPaused()) {
            this.cancel();
        }
        super.destroy();
    }

    @Override
    public void init() {
        super.init();
    }

    public void checkStatus() throws InterruptedException {
        if (this.isCancelled()) {
            throw new CodeException("Aborted by user", IProcess.ERROR_CODE_CANCELLED);
        }
        while (this.isPaused()) {
            Thread.sleep(100L);
        }
    }
}

