/*
 * Decompiled with CFR 0.152.
 */
package jmaster.jumploader.view.impl.upload.list;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import jmaster.jumploader.model.api.IModel;
import jmaster.jumploader.model.api.config.UploaderConfig;
import jmaster.jumploader.model.api.config.ViewConfig;
import jmaster.jumploader.model.api.upload.B;
import jmaster.jumploader.model.api.upload.IUploadFile;
import jmaster.jumploader.model.api.upload.IUploader;
import jmaster.jumploader.view.api.main.IMainView;
import jmaster.jumploader.view.impl.upload.list.IUploadFileListListener;
import jmaster.jumploader.view.impl.upload.list.UploadFileListCellRenderer;
import jmaster.jumploader.view.impl.upload.list.UploadFileListModel;
import jmaster.jumploader.view.impl.upload.list.dnd.FileDropListener;
import jmaster.jumploader.view.impl.upload.list.dnd.IFileDropTarget;
import jmaster.jumploader.view.impl.upload.list.dnd.UploadFileListTransferHandler;
import jmaster.jumploader.view.impl.upload.list.dnd.UploadFileTransferable;
import jmaster.util.B.A;
import jmaster.util.B.C;
import jmaster.util.lang.RunnableInfo;
import jmaster.util.swing.easylist.EasyList;

public class UploadFileList
extends EasyList
implements B,
Runnable,
IFileDropTarget,
KeyListener {
    private static final long \u016b = 9017089770972464908L;
    private static final String \u016e = "uploadFileList";
    private static final String \u0174 = "uploadFileListUpdater";
    private static final long \u016d = 500L;
    private IUploader \u0170;
    protected A \u0172 = new A(IUploadFileListListener.class);
    private UploadFileListModel \u016f;
    private long \u016c = 500L;
    private DropTarget \u016a;
    private int \u0177 = -1;
    private Icon \u0175;
    private ViewConfig \u0171;
    private IMainView \u0173;
    private UploaderConfig \u0176;

    public UploadFileList(IModel iModel, IMainView iMainView) {
        this.\u0173 = iMainView;
        this.\u0171 = iModel.getViewConfig();
        this.\u0176 = iModel.getUploaderConfig();
        this.setModel(new UploadFileListModel(iModel));
        this.\u0170 = iModel.getUploader();
        this.\u016f = (UploadFileListModel)super.getModel();
        this.\u00f2 = new UploadFileListCellRenderer(iModel, iMainView);
        this.setCellRenderer((ListCellRenderer)this.\u00f2);
        this.setLayoutOrientation(2);
        String string = \u016e + (this.\u0171.getUploadListViewName() == null ? "" : this.\u0171.getUploadListViewName());
        this.\u00f1.injectProperties(this, string);
        this.\u00f1.injectProperties(this.\u00ee, string, "emptyListLabel");
        this.addKeyListener(this);
        this.\u0170.addListener(this);
        this.addKeyListener(this);
        this.setTransferHandler(new UploadFileListTransferHandler());
        this.setDragEnabled(iModel.getUploaderConfig().isUploadQueueReorderingAllowed());
        this.\u016a = new DropTarget();
        this.setDropTarget(this.\u016a);
        this.\u016a.setComponent(this);
        this.\u016a.setActive(this.\u0170.isFileAdditionEnabled());
        try {
            this.\u016a.addDropTargetListener(new FileDropListener(this));
        }
        catch (TooManyListenersException tooManyListenersException) {
            tooManyListenersException.printStackTrace();
        }
        RunnableInfo runnableInfo = new RunnableInfo();
        runnableInfo.setRunnable(this);
        runnableInfo.setName(\u0174);
        runnableInfo.setDaemon(true);
        runnableInfo.setAutostart(true);
        iModel.getThreadManager().createThread(runnableInfo);
        this.updateView();
    }

    public long getUpdateInterval() {
        return this.\u016c;
    }

    public void setUpdateInterval(long l2) {
        this.\u016c = l2;
    }

    public Icon getInsertIcon() {
        return this.\u0175;
    }

    public void setInsertIcon(Icon icon) {
        this.\u0175 = icon;
    }

    public void addListener(IUploadFileListListener iUploadFileListListener) {
        this.\u0172.C(iUploadFileListListener);
    }

    public void removeListener(IUploadFileListListener iUploadFileListListener) {
        this.\u0172.A(iUploadFileListListener);
    }

    private void D(IUploadFile[] iUploadFileArray) {
        for (int i2 = 0; i2 < this.\u0172.C(); ++i2) {
            IUploadFileListListener iUploadFileListListener = (IUploadFileListListener)this.\u0172.A(i2);
            iUploadFileListListener.uflRemoveFilesAction(this, iUploadFileArray);
        }
    }

    private void C(String[] stringArray) {
        for (int i2 = 0; i2 < this.\u0172.C(); ++i2) {
            IUploadFileListListener iUploadFileListListener = (IUploadFileListListener)this.\u0172.A(i2);
            iUploadFileListListener.uflAddFilesAction(this, stringArray);
        }
    }

    public void uploaderFileAdditionEnabledChanged(IUploader iUploader) {
        this.\u016a.setActive(iUploader.isFileAdditionEnabled());
    }

    public void uploaderFileRemovalEnabledChanged(IUploader iUploader) {
    }

    public void uploaderFileAdded(IUploader iUploader, IUploadFile iUploadFile) {
        this.updateView();
    }

    public void uploaderFileRemoved(IUploader iUploader, IUploadFile iUploadFile) {
        this.updateView();
    }

    public void uploaderFileMoved(IUploader iUploader, IUploadFile iUploadFile, int n2) {
        this.updateView();
    }

    public void uploaderFileStatusChanged(IUploader iUploader, IUploadFile iUploadFile) {
        if (this.\u0171.isUploadViewAutoscrollToUploadingFile() && iUploadFile.isUploading()) {
            this.scrollToFile(iUploadFile);
        }
    }

    public void uploaderFilesReset(IUploader iUploader) {
        this.updateView();
    }

    public void uploaderStatusChanged(IUploader iUploader) {
    }

    public void uploaderUploadEnabledChanged(IUploader iUploader) {
    }

    public void uploaderFileAddFailed(IUploader iUploader, jmaster.jumploader.model.api.A.C c2) {
    }

    public void uploaderFileUpdated(IUploader iUploader, IUploadFile iUploadFile) {
        this.updateView();
    }

    public void uploaderFilePartitionUploaded(IUploader iUploader, IUploadFile iUploadFile) {
    }

    public void uploaderPasteEnabledChanged(IUploader iUploader) {
    }

    public void run() {
        while (!this.\u0170.isDestroyed() && !Thread.currentThread().isInterrupted()) {
            this.updateUploadingCells();
            try {
                Thread.sleep(this.\u016c);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!keyEvent.isConsumed()) {
            IUploadFile[] iUploadFileArray;
            if (keyEvent.getKeyCode() == 127 && (iUploadFileArray = this.getSelectedFiles()) != null) {
                this.D(iUploadFileArray);
                keyEvent.consume();
            }
            if (keyEvent.getKeyCode() == 65487 || keyEvent.getKeyCode() == 86) {
                this.\u0170.pasteFromClipboard();
                keyEvent.consume();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.\u0177 != -1) {
            this.\u0177 = -1;
            this.repaint();
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(UploadFileTransferable.getDataFlavor())) {
            Rectangle rectangle;
            int n2 = 0;
            Point point = dropTargetDragEvent.getLocation();
            int n3 = this.getCellAtLocation(point);
            if (n3 == -1) {
                rectangle = this.getVisibleRect();
                while (n3 == -1 && rectangle.contains(point)) {
                    n3 = this.getCellAtLocation(point);
                    --point.x;
                }
            }
            n2 = n3 != -1 ? ((rectangle = this.getCellBounds(n3, n3)).getCenterX() > (double)point.x ? n3 : n3 + 1) : this.getModel().getSize();
            if (n2 != this.\u0177) {
                this.\u0177 = n2;
                this.\u00ef.D("cell=" + n3 + ", insertIndex=" + this.\u0177);
                this.repaint();
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (this.\u0177 != -1) {
            this.\u0177 = -1;
            this.repaint();
        }
    }

    public void filesDropped(File[] fileArray) {
        if (this.\u0177 != -1) {
            this.\u0177 = -1;
            this.repaint();
        }
        String[] stringArray = new String[fileArray.length];
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            stringArray[i2] = fileArray[i2].getAbsolutePath();
        }
        this.C(stringArray);
    }

    public void textDropped(String string) {
        if (this.\u0176 != null && this.\u0176.isClipboardTextEnabled()) {
            try {
                this.\u0170.addText(string);
            }
            catch (jmaster.jumploader.model.api.A.C c2) {
                c2.printStackTrace();
            }
        }
    }

    public void moveFiles(IUploadFile[] iUploadFileArray) {
        try {
            C.C(this.\u0170, "moveFiles", new Class[]{IUploadFile[].class, Integer.TYPE}, new Object[]{iUploadFileArray, new Integer(this.\u0177)});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.\u0177 != -1) {
            this.\u0177 = -1;
            this.repaint();
        }
    }

    public void updateUploadingCells() {
        if (!C.A()) {
            C.E(this, "updateUploadingCells");
            return;
        }
        for (int i2 = 0; i2 < this.\u016f.getSize(); ++i2) {
            IUploadFile iUploadFile = this.\u016f.getUploadFile(i2);
            if (!iUploadFile.isDownloading() && !iUploadFile.isUploading() && !iUploadFile.isPreprocessing() && !iUploadFile.isServerProcessing()) continue;
            this.repaintCell(i2);
        }
    }

    public IUploadFile[] getSelectedFiles() {
        IUploadFile[] iUploadFileArray = null;
        int[] nArray = this.getSelectedIndices();
        if (nArray != null && nArray.length > 0) {
            iUploadFileArray = new IUploadFile[nArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                iUploadFileArray[i2] = this.\u016f.getUploadFile(nArray[i2]);
            }
        }
        return iUploadFileArray;
    }

    public void updateView() {
        if (!C.A()) {
            C.B(this);
            return;
        }
        this.setBackgroundVisible(this.getModel().getSize() == 0);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.\u0177 != -1 && this.\u0175 != null) {
            Rectangle rectangle = null;
            int n2 = 0;
            int n3 = 0;
            if (this.\u0177 < this.\u016f.getSize()) {
                rectangle = this.getCellBounds(this.\u0177, this.\u0177);
                n2 = rectangle.x - this.\u0175.getIconWidth() / 2;
                n3 = rectangle.y + rectangle.height / 2 - this.\u0175.getIconHeight() / 2;
            } else {
                rectangle = this.getCellBounds(this.\u016f.getSize() - 1, this.\u016f.getSize() - 1);
                n2 = rectangle.x + rectangle.width - this.\u0175.getIconWidth() / 2;
                n3 = rectangle.y + rectangle.height / 2 - this.\u0175.getIconHeight() / 2;
            }
            this.\u00ef.D("i=" + this.\u0177 + ", x=" + n2 + ", y=" + n3 + ", b=" + rectangle);
            this.\u0175.paintIcon(this, graphics, n2, n3);
            int n4 = -1;
            int n5 = -1;
            if (this.\u0177 > 0 && this.\u0177 < this.\u016f.getSize()) {
                rectangle = this.getCellBounds(this.\u0177 - 1, this.\u0177 - 1);
                n4 = rectangle.x + rectangle.width - this.\u0175.getIconWidth() / 2;
                n5 = rectangle.y + rectangle.height / 2 - this.\u0175.getIconHeight() / 2;
            }
            if (n4 != -1 && n5 != -1 && n2 != n4 && n3 != n5) {
                this.\u0175.paintIcon(this, graphics, n4, n5);
            }
        }
    }

    private boolean p() {
        boolean bl = false;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(DataFlavor.javaFileListFlavor)) {
            try {
                Object object = clipboard.getData(DataFlavor.javaFileListFlavor);
                List list = (List)object;
                File[] fileArray = new File[list.size()];
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    fileArray[i2] = (File)list.get(i2);
                }
                this.filesDropped(fileArray);
                bl = true;
            }
            catch (Exception exception) {
                this.\u00ef.E("Failed to get clipboard data", exception);
            }
        }
        return bl;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (this.\u0171.isUploadViewListShowAddDialogOnDblClick() && mouseEvent.getClickCount() == 2 && this.getCellAtLocation(mouseEvent.getPoint()) == -1) {
            this.\u0173.getUploadView().showOpenDialog();
        }
    }

    public void scrollToFile(IUploadFile iUploadFile) {
        if (!C.A()) {
            C.B(this, "scrollToFile", new Class[]{IUploadFile.class}, new Object[]{iUploadFile});
            return;
        }
        int n2 = this.\u016f.indexOfItem(iUploadFile);
        if (n2 != -1) {
            Rectangle rectangle = this.getCellBounds(n2, n2);
            this.scrollRectToVisible(rectangle);
        }
    }
}

