/*
 * Decompiled with CFR 0.152.
 */
package jmaster.jumploader.controller;

import java.awt.Image;
import java.io.File;
import java.util.MissingResourceException;
import jmaster.jumploader.app.ShutdownCleaner;
import jmaster.jumploader.model.api.IModel;
import jmaster.jumploader.model.api.file.IFileBrowser;
import jmaster.jumploader.model.api.upload.IUploadFile;
import jmaster.jumploader.model.api.upload.IUploader;
import jmaster.jumploader.view.api.file.list.IFileListView;
import jmaster.jumploader.view.api.file.list.IFileListViewListener;
import jmaster.jumploader.view.api.file.tree.IFileTreeView;
import jmaster.jumploader.view.api.file.tree.IFileTreeViewListener;
import jmaster.jumploader.view.api.image.IImageView;
import jmaster.jumploader.view.api.image.IImageViewListener;
import jmaster.jumploader.view.api.main.IMainView;
import jmaster.jumploader.view.api.upload.IUploadView;
import jmaster.jumploader.view.api.upload.IUploadViewListener;
import jmaster.jumploader.view.impl.image.ImageView;
import jmaster.util.log.A;
import jmaster.util.log.B;
import jmaster.util.property.C;
import jmaster.util.property.D;

public class Controller
implements IUploadViewListener,
IFileTreeViewListener,
IFileListViewListener,
IImageViewListener {
    private static final String \u0100 = "Controller.properties";
    protected A \u00fe = B.getInstance().getLog(this.getClass());
    protected IMainView \u00fc;
    protected IModel \u00fd;
    private String[] \u00ff;

    public Controller(IModel iModel, IMainView iMainView) {
        Object object;
        this.\u00fd = iModel;
        this.\u00fc = iMainView;
        try {
            object = jmaster.util.property.B.C().G(\u0100);
            C c2 = C.A();
            c2.A((Object)this, (D)object, null);
            this.\u00ff = ((D)object).H("addFiles");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        iMainView.getUploadView().addListener(this);
        if (iMainView.getFileTreeView() != null) {
            iMainView.getFileTreeView().addListener(this);
        }
        if (iMainView.getFileListView() != null) {
            iMainView.getFileListView().addListener(this);
        }
        if (iMainView.getImageView() != null) {
            iMainView.getImageView().addListener(this);
        }
        object = this.\u00fd.getUploader();
        if (this.\u00ff != null) {
            for (int i2 = 0; i2 < this.\u00ff.length; ++i2) {
                try {
                    object.addFile(this.\u00ff[i2]);
                    continue;
                }
                catch (jmaster.jumploader.model.api.A.C c3) {
                    this.\u00fe.E(c3, c3);
                }
            }
        }
    }

    public void uploadViewAddFilesAction(IUploadView iUploadView, String[] stringArray) {
        if (jmaster.util.B.C.A()) {
            jmaster.util.B.C.C(this, "uploadViewAddFilesAction", new Class[]{IUploadView.class, String[].class}, new Object[]{iUploadView, stringArray});
            return;
        }
        try {
            this.U().addFiles(stringArray);
        }
        catch (jmaster.jumploader.model.api.A.C c2) {
            this.\u00fe.E("Failed to add files " + stringArray, c2);
            this.\u00fc.showWarning(c2.getMessage());
        }
    }

    public void uploadViewRemoveFilesAction(IUploadView iUploadView, IUploadFile[] iUploadFileArray) {
        if (jmaster.util.B.C.A()) {
            jmaster.util.B.C.C(this, "uploadViewRemoveFilesAction", new Class[]{IUploadView.class, IUploadFile[].class}, new Object[]{iUploadView, iUploadFileArray});
            return;
        }
        try {
            for (int i2 = 0; i2 < iUploadFileArray.length; ++i2) {
                if (!iUploadFileArray[i2].isRemovable()) continue;
                this.U().removeFile(iUploadFileArray[i2]);
            }
        }
        catch (jmaster.jumploader.model.api.A.C c2) {
            this.C(c2);
        }
    }

    public void uploadViewStartAction(IUploadView iUploadView) {
        if (jmaster.util.B.C.A()) {
            jmaster.util.B.C.C(this, "uploadViewStartAction", new Class[]{IUploadView.class}, new Object[]{iUploadView});
            return;
        }
        try {
            this.U().startUpload();
        }
        catch (jmaster.jumploader.model.api.A.C c2) {
            this.C(c2);
        }
    }

    public void uploadViewStopAction(IUploadView iUploadView) {
        if (jmaster.util.B.C.A()) {
            jmaster.util.B.C.C(this, "uploadViewStopAction", new Class[]{IUploadView.class}, new Object[]{iUploadView});
            return;
        }
        try {
            this.U().stopUpload();
        }
        catch (jmaster.jumploader.model.api.A.C c2) {
            this.C(c2);
        }
    }

    public void uploadViewStopFilesAction(IUploadView iUploadView, IUploadFile[] iUploadFileArray) {
        if (jmaster.util.B.C.A()) {
            jmaster.util.B.C.C(this, "uploadViewStopFilesAction", new Class[]{IUploadView.class, IUploadFile[].class}, new Object[]{iUploadView, iUploadFileArray});
            return;
        }
        try {
            for (int i2 = 0; i2 < iUploadFileArray.length; ++i2) {
                if (!iUploadFileArray[i2].isStoppable()) continue;
                this.U().stopFileUpload(iUploadFileArray[i2]);
            }
        }
        catch (jmaster.jumploader.model.api.A.C c2) {
            this.C(c2);
        }
    }

    public void uploadViewRetryFilesAction(IUploadView iUploadView, IUploadFile[] iUploadFileArray) {
        if (jmaster.util.B.C.A()) {
            jmaster.util.B.C.C(this, "uploadViewRetryFilesAction", new Class[]{IUploadView.class, IUploadFile[].class}, new Object[]{iUploadView, iUploadFileArray});
            return;
        }
        try {
            for (int i2 = 0; i2 < iUploadFileArray.length; ++i2) {
                if (!iUploadFileArray[i2].isRetryable()) continue;
                this.U().retryFileUpload(iUploadFileArray[i2]);
            }
        }
        catch (jmaster.jumploader.model.api.A.C c2) {
            this.C(c2);
        }
    }

    public void uploadViewOpenDialogFilesSelected(IUploadView iUploadView, String[] stringArray) {
    }

    public void fileTreeViewPathChanged(IFileTreeView iFileTreeView) {
        jmaster.util.B.C.C(this, "setPath", new Class[]{File.class}, new Object[]{iFileTreeView.getPath()});
    }

    public void fileTreeViewFileDblClicked(IFileTreeView iFileTreeView, File file) {
        if (this.\u00fd.getViewConfig().isFileTreeQueueFileOnDblClick()) {
            jmaster.util.B.C.C(this, "addFile", new Class[]{File.class}, new Object[]{file});
        }
    }

    public void fileListViewPathChanged(IFileListView iFileListView, File file) {
        jmaster.util.B.C.C(this, "setPath", new Class[]{File.class}, new Object[]{file});
    }

    public void fileListViewFileDblClicked(IFileListView iFileListView, File file) {
        if (this.\u00fd.getViewConfig().isFileListQueueFileOnDblClick()) {
            jmaster.util.B.C.C(this, "addFile", new Class[]{File.class}, new Object[]{file});
        }
    }

    public void imageViewCloseAction(IImageView iImageView) {
        iImageView.setImage(null, null, null);
        this.\u00fc.setCurrentView(this.\u00fc.getProgramView());
    }

    public void imageViewSaveAction(IImageView iImageView) {
        this.\u00fc.showGlassView(true);
        jmaster.util.B.C.C(this, "imageViewSaveActionDo", new Class[]{IImageView.class}, new Object[]{iImageView});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imageViewSaveActionDo(IImageView iImageView) {
        try {
            this.A(iImageView);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.\u00fc.showGlassView(false);
            this.imageViewCloseAction(iImageView);
        }
    }

    protected void C(Exception exception) {
        this.\u00fe.E("Controller exception", exception);
        this.\u00fc.showError(exception.getMessage());
    }

    private IUploader U() {
        return this.\u00fd.getUploader();
    }

    public void setPath(File file) {
        IFileBrowser iFileBrowser;
        if (file != null && !file.equals((iFileBrowser = this.\u00fd.getFileBrowser()).getPath())) {
            iFileBrowser.setPath(file);
        }
    }

    public void addFile(File file) {
        if (file != null) {
            try {
                this.\u00fd.getUploader().addFile(file.getAbsolutePath());
            }
            catch (jmaster.jumploader.model.api.A.C c2) {
                this.\u00fe.E("Failed to add file: " + file, c2);
            }
        }
    }

    private void A(IImageView iImageView) {
        try {
            jmaster.jumploader.model.api.B.A a2 = this.\u00fd.getImageProcessor();
            File file = File.createTempFile("jumploader_", ".jpg");
            ShutdownCleaner.getInstance().addFile(file);
            if (this.\u00fe.B()) {
                this.\u00fe.D("Saving image to temp file: " + file.getAbsolutePath());
            }
            int n2 = this.\u00fd.getImageConfig().getJpegQuality();
            a2.A((Image)iImageView.getImage(), file, n2);
            jmaster.jumploader.model.impl.upload.C c2 = (jmaster.jumploader.model.impl.upload.C)iImageView.getUploadFile();
            c2.G(true);
            c2.F(true);
            this.\u00fd.getUploader().updateFile(c2, file, true);
            if (this.\u00fd.getUploaderConfig().isSaveImageTransformations()) {
                jmaster.jumploader.model.impl.image.B b2 = jmaster.jumploader.model.impl.image.B.A(c2);
                b2.A(((ImageView)iImageView).getTransformList());
            }
        }
        catch (Exception exception) {
            this.\u00fe.E(exception, exception);
            this.\u00fc.showError(exception.getMessage());
        }
    }

    public void destroy() {
        this.\u00fc = null;
        this.\u00fd = null;
    }

    public void start() {
    }
}

