/*
 * Decompiled with CFR 0.152.
 */
package jmaster.draw.view.palette;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import jmaster.draw.view.palette.PaletteFactoryParam;
import jmaster.util.lang.bean.IBeanFactory;
import jmaster.util.lang.bean.impl.GenericBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrokePaletteFactory
extends GenericBeanFactory {
    public Container container;
    public IBeanFactory<JLabel> componentFactory;
    public List<Stroke> strokeList;
    public String clientPropertyName;
    public int imageWidth;
    public int imageHeight;
    public Color strokeColor;
    public Color backgroundColor;

    public Container createStrokePalette() {
        for (Stroke stroke : this.strokeList) {
            Icon icon = this.createStrokeIcon(this.imageWidth, this.imageHeight, stroke, this.strokeColor, this.backgroundColor);
            JLabel jLabel = this.componentFactory.createBean();
            jLabel.setIcon(icon);
            jLabel.putClientProperty(this.clientPropertyName, stroke);
            this.container.add(jLabel);
        }
        return this.container;
    }

    public Icon createStrokeIcon(int n2, int n3, Stroke stroke, Color color, Color color2) {
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(color2);
        graphics2D.fillRect(0, 0, n2, n3);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
        Line2D.Double double_ = new Line2D.Double(0.0, n3 / 2, n2, n3 / 2);
        graphics2D.draw(double_);
        return new ImageIcon(bufferedImage);
    }

    @Override
    public Object createBeanInternal(Object object) throws Exception {
        Icon icon = null;
        PaletteFactoryParam paletteFactoryParam = (PaletteFactoryParam)object;
        icon = this.createStrokeIcon(paletteFactoryParam.getIconWidth(), paletteFactoryParam.getIconHeight(), (Stroke)paletteFactoryParam.getDrawingPropertyValue(), paletteFactoryParam.getForeground(), paletteFactoryParam.getBackground());
        return icon;
    }

    public static List<Stroke> createBasicStrokeList(String string, String string2, String string3) {
        ArrayList<Stroke> arrayList = new ArrayList<Stroke>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
        StringTokenizer stringTokenizer3 = new StringTokenizer(string3, ",");
        int n2 = 0;
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            int n4 = Integer.parseInt(stringTokenizer.nextToken().trim());
            if (stringTokenizer2.hasMoreTokens()) {
                n2 = Integer.parseInt(stringTokenizer2.nextToken().trim());
            }
            if (stringTokenizer3.hasMoreTokens()) {
                n3 = Integer.parseInt(stringTokenizer3.nextToken().trim());
            }
            BasicStroke basicStroke = new BasicStroke(n4, n2, n3);
            arrayList.add(basicStroke);
        }
        return arrayList;
    }
}

