/*
 * Decompiled with CFR 0.152.
 */
package jmaster.draw.view.palette;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Transparency;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmaster.draw.view.palette.PaletteFactoryParam;
import jmaster.swing.A.A;
import jmaster.util.lang.bean.IBeanFactory;
import jmaster.util.lang.bean.impl.GenericBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericColorPaletteFactory
extends GenericBeanFactory {
    static final Color[] \u01fc = new Color[]{Color.red, Color.yellow, Color.green, Color.cyan, Color.blue, Color.magenta};
    public Container container;
    public IBeanFactory<JLabel> componentFactory;
    public String clientPropertyName;
    public Color[] colors;
    public int imageWidth;
    public int imageHeight;

    public Container createColorPalette() {
        for (int i2 = 0; i2 < this.colors.length; ++i2) {
            Color color = this.colors[i2];
            Icon icon = this.createColorIcon(this.imageWidth, this.imageHeight, color);
            JLabel jLabel = this.componentFactory.createBean();
            jLabel.putClientProperty(this.clientPropertyName, color);
            jLabel.setIcon(icon);
            this.container.add(jLabel);
        }
        return this.container;
    }

    public Container createBasicColorPalette(Container container, IBeanFactory<JLabel> iBeanFactory, boolean bl, int n2, int n3, int n4) {
        Transparency transparency;
        int n5 = n3 + n4 + 1;
        int n6 = n2 + (bl ? 1 : 0);
        if (container == null) {
            container = new JPanel();
            container.setLayout(new GridLayout(n5, n6));
        }
        BufferedImage bufferedImage = null;
        if (bl) {
            bufferedImage = new BufferedImage(1, n5, 1);
            transparency = new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, n5, Color.black);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setPaint((Paint)transparency);
            graphics2D.fillRect(0, 0, 1, n5);
        }
        transparency = this.createBasicColorGradientImage(n2, 1);
        for (int i2 = 0; i2 < n5; ++i2) {
            int n7 = n5 - n3 - 1 - i2;
            int n8 = n5 - n4 * 2 - n3 - 1 + i2;
            for (int i3 = 0; i3 < n6; ++i3) {
                Color color = null;
                if (i3 == 0 && bl) {
                    color = new Color(bufferedImage.getRGB(0, i2));
                } else {
                    int n9;
                    color = new Color(((BufferedImage)transparency).getRGB(i3 - (bl ? 1 : 0), 0));
                    for (n9 = 0; n9 < n7; ++n9) {
                        color = color.brighter();
                    }
                    for (n9 = 0; n9 < n8; ++n9) {
                        color = color.darker();
                    }
                }
                Component component = iBeanFactory.createBean();
                component.setBackground(color);
                container.add(component);
            }
        }
        return container;
    }

    public Icon createColorIcon(int n2, int n3, Color color) {
        A a2 = new A();
        a2.A(n2, n3);
        a2.A(color);
        return a2;
    }

    @Override
    public Object createBeanInternal(Object object) throws Exception {
        Icon icon = null;
        PaletteFactoryParam paletteFactoryParam = (PaletteFactoryParam)object;
        icon = this.createColorIcon(paletteFactoryParam.getIconWidth(), paletteFactoryParam.getIconHeight(), (Color)paletteFactoryParam.getDrawingPropertyValue());
        return icon;
    }

    public BufferedImage createBasicColorGradientImage(int n2, int n3) {
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        int n4 = \u01fc.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            GradientPaint gradientPaint = new GradientPaint(i2 * n2 / n4, 0.0f, \u01fc[i2 % n4], (i2 + 1) * n2 / n4, 0.0f, \u01fc[(i2 + 1) % n4]);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(i2 * n2 / n4, 0, n2 / n4, n3);
        }
        return bufferedImage;
    }
}

