/*
 * Decompiled with CFR 0.152.
 */
package jmaster.draw.view;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.TransferHandler;
import jmaster.draw.B;
import jmaster.draw.C;
import jmaster.draw.J;
import jmaster.swing.components.panel.EasyPanel;
import jmaster.util.lang.bean.IBean;
import jmaster.util.lang.event.IEvent;

public class DrawingView
extends EasyPanel
implements MouseWheelListener {
    private static final long \u00c9 = -8627077398917808464L;
    public B drawingContext;
    public boolean renderDrawing;
    public boolean renderDrawingControls;

    public B getDrawingContext() {
        return this.drawingContext;
    }

    public void setDrawingContext(B b2) {
        this.drawingContext = b2;
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.drawingContext.changeZoomTicks(-mouseWheelEvent.getWheelRotation(), this.A(mouseWheelEvent.getPoint()));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        this.drawingContext.handleMouseEvent(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        this.drawingContext.handleMouseEvent(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        super.mouseEntered(mouseEvent);
        this.drawingContext.handleMouseEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        super.mouseExited(mouseEvent);
        this.drawingContext.handleMouseEvent(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.drawingContext.handleMouseEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        this.drawingContext.handleMouseEvent(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        this.drawingContext.handleMouseEvent(mouseEvent);
        TransferHandler transferHandler = this.getTransferHandler();
        if (transferHandler != null) {
            transferHandler.exportAsDrag(this, mouseEvent, 2);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        super.keyPressed(keyEvent);
        this.drawingContext.handleKeyEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        super.keyReleased(keyEvent);
        this.drawingContext.handleKeyEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        super.keyTyped(keyEvent);
        this.drawingContext.handleKeyEvent(keyEvent);
    }

    public void init() {
        super.init();
        this.drawingContext.addEventConsumer(this);
        this.drawingContext.getDrawing().addEventConsumer(this);
        this.A(this.drawingContext.getZoom(), null);
        this.addMouseWheelListener(this);
        this.addMouseMotionListener(this);
    }

    public void destroy() {
        this.drawingContext.getDrawing().removeEventConsumer(this);
        this.drawingContext.removeEventConsumer(this);
        super.destroy();
    }

    public void consumeEvent(IEvent iEvent) {
        super.consumeEvent(iEvent);
        if (iEvent.is(IBean.EVENT_PROPERTY_CHANGED)) {
            if ("cursor".equals(iEvent.getArg(0))) {
                this.setCursor((Cursor)iEvent.getArg(1));
            } else if ("viewport".equals(iEvent.getArg(0))) {
                this.P();
            }
        } else if (this.A(iEvent, C.EVENT_OBJECT_TRANSFORMED)) {
            this.A((J)iEvent.getArg(0), (Rectangle2D)iEvent.getArg(1), (Rectangle2D)iEvent.getArg(2));
        } else if (this.A(iEvent, B.EVENT_ZOOM_CHANGED)) {
            this.A((Double)iEvent.getArg(0), (Point2D)iEvent.getArg(1));
        } else if (this.A(iEvent, B.EVENT_OBJECT_SELECTED_CHANGED)) {
            this.repaint();
        } else if (this.A(iEvent, B.EVENT_OBJECT_SELECTION_CLEARED)) {
            this.repaint();
        } else if (this.A(iEvent, B.EVENT_REPAINT_REQUEST)) {
            Rectangle rectangle = (Rectangle)iEvent.getArg(1);
            if (rectangle == null) {
                this.repaint();
            } else {
                this.repaint(rectangle);
            }
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        try {
            if (this.renderDrawing) {
                this.drawingContext.renderDrawing(graphics2D);
            }
            if (this.renderDrawingControls) {
                this.drawingContext.renderDrawingControls(graphics2D);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected void A(double d2, Point2D point2D) {
        this.setPreferredSize(new Dimension((int)(this.getDrawingContext().getWidth() * d2), (int)(this.getDrawingContext().getHeight() * d2)));
        this.revalidate();
        this.repaint();
    }

    private void P() {
        this.setPreferredSize(new Dimension((int)(this.getDrawingContext().getWidth() * this.Q()), (int)(this.getDrawingContext().getHeight() * this.Q())));
        this.revalidate();
        this.repaint();
    }

    protected C R() {
        return this.drawingContext.getDrawing();
    }

    protected Point2D A(Point2D point2D, Point2D point2D2) {
        return this.drawingContext.getDrawingPoint(point2D, point2D2);
    }

    protected Point2D A(Point2D point2D) {
        return this.drawingContext.getDrawingPoint(point2D);
    }

    protected Point2D B(Point2D point2D, Point2D point2D2) {
        return this.drawingContext.getViewPoint(point2D, point2D2);
    }

    protected Point2D B(Point2D point2D) {
        return this.drawingContext.getViewPoint(point2D);
    }

    protected double Q() {
        return this.drawingContext.getZoom();
    }

    protected void A(J j2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Rectangle2D rectangle2D3 = rectangle2D.createUnion(rectangle2D2).getBounds2D();
        Rectangle2D rectangle2D4 = this.drawingContext.getViewRectangle(rectangle2D3);
        Rectangle rectangle = rectangle2D4.getBounds();
        --rectangle.x;
        --rectangle.y;
        rectangle.width += 2;
        rectangle.height += 2;
        this.\u00c1.D("--------------------------objectTransformed");
        this.\u00c1.D("newBounds=" + rectangle2D);
        this.\u00c1.D("oldBounds=" + rectangle2D2);
        this.\u00c1.D("unionBounds=" + rectangle2D3);
        this.\u00c1.D("viewBounds=" + rectangle2D4);
        this.\u00c1.D("repaintRect=" + rectangle);
        this.repaint(rectangle);
    }
}

