/*
 * Decompiled with CFR 0.152.
 */
package jmaster.draw.impl;

import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import jmaster.util.lang.LangHelper;
import jmaster.util.lang.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeomHelper {
    public static final int UNDEFINED = -1;
    public static final int ANCHOR_N = 0;
    public static final int ANCHOR_NW = 1;
    public static final int ANCHOR_W = 2;
    public static final int ANCHOR_SW = 3;
    public static final int ANCHOR_S = 4;
    public static final int ANCHOR_SE = 5;
    public static final int ANCHOR_E = 6;
    public static final int ANCHOR_NE = 7;
    public static final int ANCHOR_C = 8;
    public static final int[] OPPOSITE_ANCHORS = new int[]{4, 5, 6, 7, 0, 1, 2, 3};
    public static final double[] ANCHOR_LOCATIONS_X = new double[]{0.5, 0.0, 0.0, 0.0, 0.5, 1.0, 1.0, 1.0, 0.5};
    public static final int[] ANCHOR_DIRECTIONS_X = new int[]{0, -1, -1, -1, 0, 1, 1, 1, 0};
    public static final double[] ANCHOR_LOCATIONS_Y = new double[]{0.0, 0.0, 0.5, 1.0, 1.0, 1.0, 0.5, 0.0, 0.5};
    public static final int[] ANCHOR_DIRECTIONS_Y = new int[]{-1, -1, 0, 1, 1, 1, 0, -1, 0};
    public static final int[] ANCHOR_CURSOR_RESIZE_IDS = new int[]{8, 6, 10, 4, 9, 5, 11, 7, 13};
    public DecimalFormat doubleFormat = new DecimalFormat("0.000");

    public String toString(Rectangle2D rectangle2D) {
        return "[" + this.toString(rectangle2D.getX()) + ", " + this.toString(rectangle2D.getY()) + ", " + this.toString(rectangle2D.getWidth()) + ", " + this.toString(rectangle2D.getHeight()) + "]";
    }

    public String toString(double d2) {
        return this.doubleFormat.format(d2);
    }

    public String toString(AffineTransform affineTransform) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("translate: (" + this.toString(affineTransform.getTranslateX()) + ", " + this.toString(affineTransform.getTranslateY()) + "), ");
        stringBuffer.append("scale: (" + this.toString(affineTransform.getScaleX()) + ", " + this.toString(affineTransform.getScaleY()) + "), ");
        stringBuffer.append("shear: (" + this.toString(affineTransform.getShearX()) + ", " + this.toString(affineTransform.getShearY()) + ")");
        return stringBuffer.toString();
    }

    public Cursor getAnchorResizeCursor(int n2) {
        return new Cursor(ANCHOR_CURSOR_RESIZE_IDS[n2]);
    }

    public Point2D getPoint(double d2, double d3) {
        return new Point2D.Double(d2, d3);
    }

    public AffineTransform getTransform(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl, boolean bl2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(-rectangle2D.getX(), -rectangle2D.getY());
        if (bl || bl2) {
            affineTransform.preConcatenate(AffineTransform.getScaleInstance(bl ? -1.0 : 1.0, bl2 ? -1.0 : 1.0));
            affineTransform.preConcatenate(AffineTransform.getTranslateInstance(bl ? rectangle2D.getWidth() : 0.0, bl2 ? rectangle2D.getHeight() : 0.0));
        }
        affineTransform.preConcatenate(AffineTransform.getScaleInstance(rectangle2D2.getWidth() / rectangle2D.getWidth(), rectangle2D2.getHeight() / rectangle2D.getHeight()));
        affineTransform.preConcatenate(AffineTransform.getTranslateInstance(rectangle2D2.getX(), rectangle2D2.getY()));
        return affineTransform;
    }

    public AffineTransform getTransform(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        return this.getTransform(rectangle2D, rectangle2D2, false, false);
    }

    public Point2D getAnchorLocation(int n2, Rectangle2D rectangle2D) {
        double d2 = rectangle2D.getX() + ANCHOR_LOCATIONS_X[n2] * rectangle2D.getWidth();
        double d3 = rectangle2D.getY() + ANCHOR_LOCATIONS_Y[n2] * rectangle2D.getHeight();
        return new Point2D.Double(d2, d3);
    }

    public Shape getAnchoredShape(int n2, Shape shape, Rectangle2D rectangle2D, boolean bl) {
        Point2D point2D = this.getAnchorLocation(n2, rectangle2D);
        Rectangle2D rectangle2D2 = shape.getBounds2D();
        if (bl) {
            point2D.setLocation(point2D.getX() - rectangle2D2.getWidth() / 2.0, point2D.getY() - rectangle2D2.getHeight() / 2.0);
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(point2D.getX() - rectangle2D2.getX(), point2D.getY() - rectangle2D2.getY());
        Shape shape2 = affineTransform.createTransformedShape(shape);
        return shape2;
    }

    public int getOppositeAnchor(int n2) {
        return n2 >= OPPOSITE_ANCHORS.length || n2 < 0 ? -1 : OPPOSITE_ANCHORS[n2];
    }

    public Point2D getOppositeAnchorLocation(int n2, Rectangle2D rectangle2D) {
        return this.getAnchorLocation(this.getOppositeAnchor(n2), rectangle2D);
    }

    public boolean isPrimaryAnchor(int n2) {
        return 0 == n2 || 2 == n2 || 4 == n2 || 6 == n2;
    }

    public boolean isSecondaryAnchor(int n2) {
        return 1 == n2 || 3 == n2 || 5 == n2 || 7 == n2;
    }

    public boolean isVerticalAnchor(int n2) {
        return 0 == n2 || 4 == n2;
    }

    public boolean isHorizontalAnchor(int n2) {
        return 2 == n2 || 6 == n2;
    }

    public boolean isBottomAnchor(int n2) {
        return 4 == n2 || 5 == n2 || 3 == n2;
    }

    public boolean isLeftAnchor(int n2) {
        return 2 == n2 || 3 == n2 || 1 == n2;
    }

    public boolean isTopAnchor(int n2) {
        return 0 == n2 || 7 == n2 || 1 == n2;
    }

    public boolean isRightAnchor(int n2) {
        return 6 == n2 || 5 == n2 || 7 == n2;
    }

    public int getSiblingAnchor(int n2, boolean bl) {
        int n3 = n2 + (bl ? -1 : 1);
        if (n3 == -1) {
            n3 = 7;
        } else if (n3 == 8) {
            n3 = 0;
        }
        return n3;
    }

    public Point2D getTranslatedPoint(Point2D point2D, double d2, double d3) {
        return new Point2D.Double(point2D.getX() + d2, point2D.getY() + d3);
    }

    public int getAnchorXAxisDirection(int n2) {
        return ANCHOR_DIRECTIONS_X[n2];
    }

    public int getAnchorYAxisDirection(int n2) {
        return ANCHOR_DIRECTIONS_Y[n2];
    }

    public Rectangle getRectangle(Rectangle rectangle, Insets insets) {
        Rectangle rectangle2 = rectangle;
        if (insets != null) {
            rectangle2 = new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
        }
        return rectangle2;
    }

    public GeneralPath createGeneralPath(List<Point2D.Double> list, boolean bl) {
        GeneralPath generalPath = new GeneralPath();
        if (!LangHelper.isEmpty(list)) {
            boolean bl2 = true;
            for (Point2D.Double double_ : list) {
                if (bl2) {
                    generalPath.moveTo(double_.getX(), double_.getY());
                    bl2 = false;
                    continue;
                }
                generalPath.lineTo(double_.getX(), double_.getY());
            }
            if (bl) {
                generalPath.closePath();
            }
        }
        return generalPath;
    }

    public GeneralPath createGeneralPath(String string, boolean bl) {
        List<Point2D.Double> list = this.parsePoints(string);
        return this.createGeneralPath(list, bl);
    }

    public List<Point2D.Double> parsePoints(String string) {
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        int n2 = 0;
        do {
            if ((n2 = string.indexOf(40, n2)) == -1) continue;
            int n3 = string.indexOf(41, n2);
            if (n3 != -1) {
                String string2 = string.substring(n2 + 1, n3);
                arrayList.add(this.parsePoint(string2));
            }
            ++n2;
        } while (n2 != -1);
        return arrayList;
    }

    public Point2D.Double parsePoint(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        double d2 = StringHelper.parseDouble(stringTokenizer.nextToken());
        double d3 = StringHelper.parseDouble(stringTokenizer.nextToken());
        Point2D.Double double_ = new Point2D.Double(d2, d3);
        return double_;
    }
}

