/*
 * Decompiled with CFR 0.152.
 */
package jmaster.draw;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmaster.context.D;
import jmaster.draw.B;
import jmaster.draw.C;
import jmaster.draw.F;
import jmaster.draw.H;
import jmaster.draw.J;
import jmaster.draw.impl.control.DrawingControlTransform;
import jmaster.draw.impl.object.DrawObjectBitmap;
import jmaster.draw.view.ImageView;
import jmaster.jumploader.app.ShutdownCleaner;
import jmaster.jumploader.model.api.IModel;
import jmaster.jumploader.model.api.common.IAttribute;
import jmaster.jumploader.model.api.upload.IUploadFile;
import jmaster.jumploader.view.api.IGenericView;
import jmaster.jumploader.view.api.main.IMainView;
import jmaster.jumploader.view.impl.image.dialog.GenericDialog;
import jmaster.jumploader.view.impl.image.dialog.blur.FilterGblurView;
import jmaster.jumploader.view.impl.image.dialog.contrast.FilterContrastView;
import jmaster.jumploader.view.impl.image.dialog.hsb.FilterHsbView;
import jmaster.jumploader.view.impl.image.dialog.resize.ResizeView;
import jmaster.jumploader.view.impl.image.dialog.unsharp.FilterUnsharpView;
import jmaster.util.lang.LangHelper;
import jmaster.util.lang.event.IEvent;
import jmaster.util.lang.event.IEventConsumer;
import jmaster.util.lang.list.IList;
import jmaster.util.log.A;
import jmaster.util.swing.GUIHelper;
import jmaster.util.swing.SwingUtil;
import z.A.B.A.K;
import z.A.B.A.L;
import z.A.B.A.M;
import z.A.B.A.O;

public class JumploaderDrawController
implements ActionListener,
ChangeListener,
IEventConsumer,
jmaster.context.B {
    private static final long \u0207 = -8627077398917808464L;
    public static final int[] ZOOM_VALUES = new int[]{10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 150, 200, 250, 300, 400, 500, 600, 700, 800, 900, 1000, 1100, 1200, 1300, 1400, 1500, 1600};
    static final String \u020b = "drawing";
    protected A \u0208 = jmaster.util.log.B.getInstance().getLog(this.getClass());
    protected GUIHelper \u0205 = GUIHelper.getInstance();
    public IModel model;
    public B drawingContext;
    public jmaster.jumploader.model.impl.upload.C uploadFile;
    public ImageView imageView;
    public JButton closeButton;
    public JButton saveButton;
    public JButton metadataButton;
    public JButton scaleButton;
    public GenericDialog resizeDialog;
    public ResizeView resizeView;
    public JButton cmdRotateCw;
    public JButton cmdRotateCcw;
    public JButton cmdFilters;
    public JPopupMenu popupFilters;
    public JMenuItem menuItemFilterGrayscale;
    public JMenuItem menuItemFilterSepia;
    public JMenuItem menuItemFilterGblur;
    public JMenuItem menuItemFilterContrast;
    public JMenuItem menuItemFilterHsb;
    public JMenuItem menuItemFilterUnsharp;
    private boolean \u0213;
    private BufferedImage \u020f;
    public ImageIcon sepiaBitmapIcon;
    protected GenericDialog \u020d;
    protected FilterGblurView \u020a;
    protected FilterContrastView \u020c;
    protected GenericDialog \u0206;
    protected FilterHsbView \u0210;
    protected GenericDialog \u0209;
    protected FilterUnsharpView \u020e;
    protected GenericDialog \u0211;
    public JLabel zoomIconLabel;
    public JSlider zoomSlider;
    public JTextField zoomInput;
    private D \u0212;
    public JLabel drawingSizeLabel;
    public String drawingSizeLabelText;
    public JLabel selectionLabel;
    public String selectionLabelText;
    public JLabel positionLabel;
    public String positionLabelText;
    public JButton cmdFlipH;
    public JButton cmdFlipV;

    public B getDrawingContext() {
        return this.drawingContext;
    }

    public void setDrawingContext(B b2) {
        this.drawingContext = b2;
    }

    public boolean isEditing() {
        return this.uploadFile != null;
    }

    public void init() {
        this.drawingContext.addEventConsumer(this);
        this.drawingContext.getDrawingControls().addEventConsumer(this);
        this.saveButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.metadataButton.addActionListener(this);
        this.scaleButton.addActionListener(this);
        this.cmdRotateCw.addActionListener(this);
        this.cmdRotateCcw.addActionListener(this);
        this.cmdFlipH.addActionListener(this);
        this.cmdFlipV.addActionListener(this);
        this.cmdFilters.addActionListener(this);
        this.menuItemFilterContrast.addActionListener(this);
        this.menuItemFilterGrayscale.addActionListener(this);
        this.menuItemFilterSepia.addActionListener(this);
        this.menuItemFilterGblur.addActionListener(this);
        this.menuItemFilterHsb.addActionListener(this);
        this.menuItemFilterUnsharp.addActionListener(this);
        this.zoomSlider.setMinimum(0);
        this.zoomSlider.setMaximum(ZOOM_VALUES.length - 1);
        this.zoomSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.zoomSlider.setPaintTicks(true);
        this.zoomSlider.setMajorTickSpacing(100);
        this.zoomSlider.setMinorTickSpacing(1);
        this.zoomSlider.setPaintLabels(false);
        this.zoomSlider.setSnapToTicks(true);
        this.zoomSlider.setValue(9);
        this.zoomSlider.addChangeListener(this);
        this.drawingSizeLabelText = this.drawingSizeLabel.getText();
        this.selectionLabelText = this.selectionLabel.getText();
        this.positionLabelText = this.positionLabel.getText();
        this.\u00c9();
        this.\u00c6();
        this.metadataButton.setVisible(this.model.getUploaderConfig().isUseMetadata());
    }

    public void destroy() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        z.A.B.A.J j2;
        if (actionEvent.getSource().equals(this.metadataButton)) {
            this.showMetadataDialog();
        }
        if (actionEvent.getSource().equals(this.scaleButton)) {
            this.showResizeDialog(true);
        }
        if (actionEvent.getSource().equals(this.cmdRotateCw)) {
            this.quadrantRotateDrawing(1);
        }
        if (actionEvent.getSource().equals(this.cmdRotateCcw)) {
            this.quadrantRotateDrawing(-1);
        }
        if (actionEvent.getSource().equals(this.cmdFlipH)) {
            this.flipDrawing(true, false);
        }
        if (actionEvent.getSource().equals(this.cmdFlipV)) {
            this.flipDrawing(false, true);
        }
        if (actionEvent.getSource().equals(this.saveButton)) {
            jmaster.util.B.C.D(this, "saveDrawing");
        }
        if (actionEvent.getSource().equals(this.closeButton)) {
            this.discardDrawing(this.uploadFile);
            jmaster.util.B.C.D(this, "closeDrawing");
        }
        if (actionEvent.getSource().equals(this.cmdFilters)) {
            this.popupFilters.show(this.cmdFilters.getParent(), this.cmdFilters.getX(), this.cmdFilters.getY() + this.cmdFilters.getHeight());
        }
        if (actionEvent.getSource().equals(this.menuItemFilterGrayscale)) {
            this.A(new M());
        }
        if (actionEvent.getSource().equals(this.menuItemFilterSepia)) {
            this.\u00c7();
        }
        if (actionEvent.getSource().equals(this.menuItemFilterGblur)) {
            this.showFilterGblurDialog(true);
            if (0 == this.\u020d.getActionCode()) {
                this.A(new O(this.\u020a.getRadiusValue()));
            }
        }
        if (actionEvent.getSource().equals(this.menuItemFilterContrast)) {
            this.showFilterContrastDialog(true);
            if (0 == this.\u0206.getActionCode()) {
                j2 = new L();
                j2.F(this.\u020c.getContrastValue());
                j2.E(this.\u020c.getBrightnessValue());
                this.A(j2);
            }
        }
        if (actionEvent.getSource().equals(this.menuItemFilterHsb)) {
            this.showFilterHsbDialog(true);
            if (0 == this.\u0209.getActionCode()) {
                j2 = this.\u0210.getFilter();
                this.A(j2);
            }
        }
        if (actionEvent.getSource().equals(this.menuItemFilterUnsharp)) {
            this.showFilterUnsharpDialog(true);
            if (0 == this.\u0211.getActionCode()) {
                j2 = this.\u020e.getFilter();
                this.A(j2);
            }
        }
    }

    public void showFilterUnsharpDialog(boolean bl) {
        if (this.\u0211 == null) {
            this.\u020e = new FilterUnsharpView(this.model, this.model.getMain().getView());
            this.\u0211 = new GenericDialog(SwingUtil.getParentFrame((Component)((Object)this.model.getMain().getView())), this.\u020e);
            this.\u0205.injectProperties(this.\u0211, "filterUnsharpDialog");
        }
        if (bl) {
            this.\u020e.setImage(this.\u00c4());
            this.\u020e.reset();
            this.\u0211.popup();
        } else {
            this.\u0211.dispose();
        }
    }

    public void showFilterHsbDialog(boolean bl) {
        if (this.\u0209 == null) {
            this.\u0210 = new FilterHsbView(this.model, this.model.getMain().getView());
            this.\u0209 = new GenericDialog(SwingUtil.getParentFrame((Component)((Object)this.model.getMain().getView())), this.\u0210);
            this.\u0205.injectProperties(this.\u0209, "filterHsbDialog");
        }
        if (bl) {
            this.\u0210.setImage(this.\u00c4());
            this.\u0210.reset();
            this.\u0209.popup();
        } else {
            this.\u0209.dispose();
        }
    }

    public void showFilterContrastDialog(boolean bl) {
        if (this.\u0206 == null) {
            this.\u020c = new FilterContrastView(this.model, this.model.getMain().getView());
            this.\u0206 = new GenericDialog(SwingUtil.getParentFrame((Component)((Object)this.model.getMain().getView())), this.\u020c);
            this.\u0205.injectProperties(this.\u0206, "filterContrastDialog");
        }
        if (bl) {
            this.\u020c.setImage(this.\u00c4());
            this.\u020c.resetBrightnessValue();
            this.\u020c.resetContrastValue();
            this.\u0206.popup();
        } else {
            this.\u0206.dispose();
        }
    }

    public void showFilterGblurDialog(boolean bl) {
        if (this.\u020d == null) {
            this.\u020a = new FilterGblurView(this.model, this.model.getMain().getView());
            this.\u020d = new GenericDialog(SwingUtil.getParentFrame((Component)((Object)this.model.getMain().getView())), this.\u020a);
            this.\u0205.injectProperties(this.\u020d, "filterGblurDialog");
        }
        if (bl) {
            this.\u020a.setImage(this.\u00c4());
            this.\u020a.resetRadiusValue();
            this.\u020d.popup();
        } else {
            this.\u020d.dispose();
        }
    }

    private BufferedImage \u00c4() {
        if (this.\u020f == null) {
            jmaster.jumploader.model.api.B.A a2 = this.model.getImageProcessor();
            this.\u020f = a2.D(a2.A(this.\u00c5(), this.model.getViewConfig().getThumbWidth(), this.model.getViewConfig().getThumbHeight(), null, true));
        }
        return this.\u020f;
    }

    private void \u00c7() {
        jmaster.jumploader.model.api.B.A a2 = this.model.getImageProcessor();
        K k2 = new K(a2.D(this.sepiaBitmapIcon.getImage()));
        z.A.B.A.B b2 = new z.A.B.A.B();
        b2.A(k2);
        this.A(b2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDrawing() {
        IMainView iMainView = this.model.getMain().getView();
        try {
            iMainView.showGlassView(true);
            C c2 = this.getDrawing(this.uploadFile);
            C c3 = this.drawingContext.getDrawing();
            c2.clear();
            c2.add(c3);
            c2.setViewport(c3.getViewport());
            jmaster.jumploader.model.api.B.A a2 = this.model.getImageProcessor();
            File file = File.createTempFile("jumploader_", ".jpg");
            ShutdownCleaner.getInstance().addFile(file);
            if (this.\u0208.B()) {
                this.\u0208.D("Saving image to temp file: " + file.getAbsolutePath());
            }
            int n2 = this.model.getImageConfig().getJpegQuality();
            BufferedImage bufferedImage = this.drawingContext.renderToBufferedImage();
            a2.A((Image)bufferedImage, file, n2);
            this.uploadFile.G(true);
            this.uploadFile.F(true);
            this.model.getUploader().updateFile(this.uploadFile, file, true);
            this.closeDrawing();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            iMainView.setCurrentView(iMainView.getProgramView());
            iMainView.showGlassView(false);
        }
    }

    public void closeDrawing() {
        IMainView iMainView = this.model.getMain().getView();
        iMainView.setCurrentView(iMainView.getProgramView());
        this.uploadFile = null;
        this.drawingContext.getDrawing().clear();
        this.drawingContext.clearSelection();
        this.drawingContext.setTool(null);
        this.\u020f = null;
    }

    public void quadrantRotateDrawing(int n2) {
        Rectangle2D rectangle2D = this.drawingContext.getViewport();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.quadrantRotate(n2, rectangle2D.getCenterX(), rectangle2D.getCenterY());
        this.drawingContext.getDrawing().transform(affineTransform);
        if (n2 % 2 != 0) {
            this.drawingContext.setViewport(affineTransform.createTransformedShape(rectangle2D).getBounds2D());
        }
    }

    public void flipDrawing(boolean bl, boolean bl2) {
        Rectangle2D rectangle2D = this.drawingContext.getViewport();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(bl ? -1.0 : 1.0, bl2 ? -1.0 : 1.0);
        affineTransform.translate(bl ? -rectangle2D.getMinX() * 2.0 - rectangle2D.getWidth() : 0.0, bl2 ? -rectangle2D.getMinY() * 2.0 - rectangle2D.getHeight() : 0.0);
        this.drawingContext.getDrawing().transform(affineTransform);
    }

    public void showMetadataDialog() {
        Point point = this.metadataButton.getLocationOnScreen();
        this.model.getMain().getView().getUploadView().showMetadata(this.uploadFile, point);
    }

    public void showResizeDialog(boolean bl) {
        if (this.resizeDialog == null) {
            this.resizeView = new ResizeView(this.model);
            this.resizeDialog = new GenericDialog(SwingUtil.getParentFrame(this.scaleButton), this.resizeView);
            this.\u0205.injectProperties(this.resizeDialog, "resizeDialog");
        }
        if (bl) {
            this.resizeView.setSourceSize(new Dimension((int)this.drawingContext.getWidth(), (int)this.drawingContext.getHeight()));
            this.resizeDialog.popup();
            if (this.resizeDialog.getActionCode() == 0) {
                int n2 = this.resizeView.getTargetWidth();
                int n3 = this.resizeView.getTargetHeight();
                if (n2 > 0 && n3 > 0) {
                    this.scaleDrawing(n2, n3, this.resizeView.isKeepAspectRatio());
                }
            }
        } else {
            this.resizeDialog.dispose();
        }
    }

    public void scaleDrawing(double d2, double d3, boolean bl) {
        double d4 = d2 / this.drawingContext.getWidth();
        double d5 = d3 / this.drawingContext.getHeight();
        if (bl) {
            d4 = d5 = Math.min(d4, d5);
        }
        this.drawingContext.getDrawing().scale(d4, d5);
        this.drawingContext.setViewport(new Rectangle2D.Double(0.0, 0.0, this.drawingContext.getWidth() * d4, this.drawingContext.getHeight() * d5));
    }

    public void editImage(IUploadFile iUploadFile) {
        this.uploadFile = (jmaster.jumploader.model.impl.upload.C)iUploadFile;
        try {
            Object object;
            IMainView iMainView = this.model.getMain().getView();
            IGenericView iGenericView = iMainView.getCurrentView();
            iMainView.setCurrentView(this.imageView);
            C c2 = this.drawingContext.getDrawing();
            c2.clear();
            C c3 = this.getDrawing(iUploadFile);
            if (c3 == null) {
                c3 = (C)this.\u0212.getBean("newDrawing");
                this.setDrawing(iUploadFile, c3);
                this.model.getUploader().applyTransformations(iUploadFile);
                try {
                    object = this.model.getImageProcessor().D(iUploadFile.getFile());
                    BufferedImage bufferedImage = this.model.getImageProcessor().D((Image)object);
                    DrawObjectBitmap drawObjectBitmap = new DrawObjectBitmap();
                    drawObjectBitmap.setSelectable(false);
                    drawObjectBitmap.setImage(bufferedImage);
                    c3.add(drawObjectBitmap, null);
                    c3.setViewport(new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight()));
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    JOptionPane.showMessageDialog((Component)((Object)iMainView), "Image is too large to load");
                    iMainView.setCurrentView(iGenericView);
                }
            }
            c2.add(c3);
            this.drawingContext.setViewport(c3.getViewport());
            try {
                object = new Double(this.model.getViewConfig().getImageViewZoom());
                this.drawingContext.changeZoom((Double)object / 100.0, null);
            }
            catch (Exception exception) {
                this.zoomToFit();
            }
            this.\u00c9();
        }
        catch (Exception exception) {
            this.\u0208.E(exception, exception);
        }
    }

    public C getDrawing(IUploadFile iUploadFile) {
        C c2 = null;
        IAttribute iAttribute = iUploadFile.getAttributeSet().getAttributeByName(\u020b);
        if (iAttribute != null) {
            c2 = (C)iAttribute.getValue();
        }
        return c2;
    }

    public void setDrawing(IUploadFile iUploadFile, C c2) {
        IAttribute iAttribute = iUploadFile.getAttributeSet().getAttributeByName(\u020b);
        if (iAttribute == null) {
            iUploadFile.getAttributeSet().createAttribute(\u020b, c2).setSendToServer(false);
        } else {
            iAttribute.setValue(c2);
        }
    }

    public void discardDrawing(IUploadFile iUploadFile) {
        IAttribute iAttribute = iUploadFile.getAttributeSet().getAttributeByName(\u020b);
        if (iAttribute != null) {
            iUploadFile.getAttributeSet().removeAttribute(iAttribute);
        }
    }

    public void zoomToFit() {
        Point2D point2D = null;
        Rectangle rectangle = this.imageView.getVisibleRect();
        double d2 = Math.min(rectangle.getWidth() / this.drawingContext.getWidth(), rectangle.getHeight() / this.drawingContext.getHeight());
        this.drawingContext.changeZoom(d2, point2D);
    }

    private void A(BufferedImageOp bufferedImageOp) {
        this.showWaitDialog(true);
        jmaster.util.B.C.C(this, "applyBufferedImageOpDo", new Class[]{BufferedImageOp.class}, new Object[]{bufferedImageOp});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyBufferedImageOpDo(BufferedImageOp bufferedImageOp) {
        try {
            BufferedImage bufferedImage = this.\u00c5();
            BufferedImage bufferedImage2 = bufferedImageOp.filter(bufferedImage, null);
            this.A(bufferedImage2, true);
        }
        finally {
            this.showWaitDialog(false);
        }
    }

    private DrawObjectBitmap \u00c8() {
        DrawObjectBitmap drawObjectBitmap = null;
        C c2 = this.drawingContext.getDrawing();
        for (int i2 = c2.getSize(null) - 1; drawObjectBitmap == null && i2 >= 0; --i2) {
            J j2 = (J)c2.get(null, i2);
            if (!(j2 instanceof DrawObjectBitmap)) continue;
            drawObjectBitmap = (DrawObjectBitmap)j2;
        }
        return drawObjectBitmap;
    }

    private BufferedImage \u00c5() {
        BufferedImage bufferedImage = null;
        DrawObjectBitmap drawObjectBitmap = this.\u00c8();
        if (drawObjectBitmap != null) {
            bufferedImage = this.model.getImageProcessor().D(drawObjectBitmap.getImage());
        }
        return bufferedImage;
    }

    private void A(Image image, boolean bl) {
        jmaster.jumploader.model.api.B.A a2 = this.model.getImageProcessor();
        this.\u00c8().setImage(image);
        this.\u020f = a2.D(a2.A(image, this.model.getViewConfig().getThumbWidth(), this.model.getViewConfig().getThumbHeight(), null, true));
        this.\u0213 = bl;
    }

    public void showWaitDialog(boolean bl) {
        this.model.getMain().getView().showGlassView(bl);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource().equals(this.zoomSlider)) {
            this.zoomInput.setText("" + ZOOM_VALUES[this.zoomSlider.getValue()] + "%");
            int n2 = ZOOM_VALUES[this.zoomSlider.getValue()];
            this.drawingContext.changeZoom((double)n2 / 100.0, null);
        }
    }

    public void consumeEvent(IEvent iEvent) {
        H h2;
        if (iEvent.isPropertyChange("lastMouseAction")) {
            this.A(this.drawingContext.getLastMouseAction());
        } else if (LangHelper.equals(iEvent.getEventProducer(), this.drawingContext.getDrawingControls())) {
            if (iEvent.is(IList.EVENT_LIST_ELEMENT_ADDED)) {
                h2 = (H)iEvent.getArg(0);
                if (h2 instanceof DrawingControlTransform) {
                    h2.addEventConsumer(this);
                }
            } else if (iEvent.is(IList.EVENT_LIST_ELEMENT_REMOVED) && (h2 = (H)iEvent.getArg(0)) instanceof DrawingControlTransform) {
                h2.removeEventConsumer(this);
                this.A((Rectangle2D)null);
            }
        }
        if (iEvent.is(DrawingControlTransform.EVENT_TRANSFORM_CHANGED, DrawingControlTransform.EVENT_RESET, DrawingControlTransform.EVENT_TRANSFORM_APPLIED)) {
            h2 = (DrawingControlTransform)iEvent.getEventProducer();
            Rectangle2D rectangle2D = ((DrawingControlTransform)h2).getTransformedRectangle();
            this.A(rectangle2D);
        }
        if (iEvent.isPropertyChange("zoom")) {
            this.\u00c9();
        } else if (iEvent.isPropertyChange("viewport")) {
            this.\u00c6();
        }
    }

    private void A(F f2) {
        Point2D point2D = f2.C();
        this.positionLabel.setVisible(point2D != null && !f2.D());
        if (point2D != null) {
            this.positionLabel.setText(this.positionLabelText + (int)point2D.getX() + ", " + (int)point2D.getY());
        }
    }

    private void A(Rectangle2D rectangle2D) {
        this.selectionLabel.setVisible(rectangle2D != null);
        if (rectangle2D != null) {
            this.selectionLabel.setText(this.selectionLabelText + "(" + (int)rectangle2D.getMinX() + ", " + (int)rectangle2D.getMinY() + ") - (" + (int)rectangle2D.getMaxX() + ", " + (int)rectangle2D.getMaxY() + "), " + (int)rectangle2D.getWidth() + "x" + (int)rectangle2D.getHeight());
        }
    }

    private void \u00c6() {
        this.drawingSizeLabel.setVisible(this.drawingContext.getViewport() != null);
        if (this.drawingContext.getViewport() != null) {
            this.drawingSizeLabel.setText(this.drawingSizeLabelText + (int)this.drawingContext.getViewport().getWidth() + "x" + (int)this.drawingContext.getViewport().getHeight());
        }
    }

    private void \u00c9() {
        int n2 = (int)(this.drawingContext.getZoom() * 100.0);
        this.zoomInput.setText("" + n2);
        int n3 = 0;
        for (int i2 = 0; i2 < ZOOM_VALUES.length; ++i2) {
            if (n2 > ZOOM_VALUES[i2]) continue;
            n3 = i2;
            break;
        }
        this.zoomSlider.setValue(n3);
    }

    public void setContext(D d2) {
        this.\u0212 = d2;
    }
}

