/*
 * Decompiled with CFR 0.152.
 */
package jmaster.context.impl.def.value;

import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.Date;
import java.util.StringTokenizer;
import jmaster.context.impl.Context;
import jmaster.context.impl.def.AbstractDef;
import jmaster.context.impl.def.value.AbstractValueDef;
import jmaster.util.lang.LangHelper;
import jmaster.util.lang.StringHelper;

public class TextDef
extends AbstractValueDef {
    public static final String DEFAULT_DELIM = ",";
    public static final Class[] CLASSES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, String.class, Date.class};
    private String Z;

    public TextDef() {
    }

    public TextDef(String string) {
        this.setText(string);
    }

    public String getText() {
        return this.Z;
    }

    public void setText(String string) {
        this.Z = string;
    }

    public Class[] getPropertyClasses() {
        return CLASSES;
    }

    public Object loadProperty(Class clazz, String string) {
        Object object = null;
        if (!StringHelper.isEmpty(string)) {
            if (clazz == null) {
                object = string;
            } else if (clazz.isArray()) {
                Class<?> clazz2 = clazz.getComponentType();
                StringTokenizer stringTokenizer = new StringTokenizer(string, DEFAULT_DELIM);
                int n2 = stringTokenizer.countTokens();
                Object object2 = Array.newInstance(clazz2, n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string2 = stringTokenizer.nextToken();
                    Object object3 = this.parse(clazz2, string2);
                    Array.set(object2, i2, object3);
                }
                object = object2;
            } else {
                object = this.parse(clazz, string);
            }
        }
        return object;
    }

    public Object parse(Class clazz, String string) {
        Object object = null;
        if (Boolean.TYPE.equals(clazz) || Boolean.class.equals((Object)clazz)) {
            object = new Boolean("true".equalsIgnoreCase(string));
        } else if (Byte.TYPE.equals(clazz) || Byte.class.equals((Object)clazz)) {
            object = new Byte(StringHelper.parseByte(string));
        } else if (Character.TYPE.equals(clazz) || Character.class.equals((Object)clazz)) {
            object = new Character(string.charAt(0));
        } else if (Double.TYPE.equals(clazz) || Double.class.equals((Object)clazz)) {
            object = new Double(Double.parseDouble(string));
        } else if (Float.TYPE.equals(clazz) || Float.class.equals((Object)clazz)) {
            object = new Float(Float.parseFloat(string));
        } else if (Integer.TYPE.equals(clazz) || Integer.class.equals((Object)clazz)) {
            object = new Integer(StringHelper.parseInt(string));
        } else if (Long.TYPE.equals(clazz) || Long.class.equals((Object)clazz)) {
            object = new Long(StringHelper.parseLong(string));
        } else if (Short.TYPE.equals(clazz) || Short.class.equals((Object)clazz)) {
            object = new Short(StringHelper.parseShort(string));
        } else if (String.class.equals((Object)clazz)) {
            object = string;
        } else if (Date.class.equals((Object)clazz)) {
            try {
                object = StringHelper.parseDate(string);
            }
            catch (ParseException parseException) {
                LangHelper.handleRuntime(parseException);
            }
        } else {
            object = string;
        }
        return object;
    }

    public void processCharacterData(String string) {
        this.Z = string;
    }

    public void processChildDef(AbstractDef abstractDef) {
        super.processChildDef(abstractDef);
    }

    public Object getValueObject(Context context, Class clazz) {
        return this.loadProperty(clazz, this.Z);
    }
}

