/*
 * Decompiled with CFR 0.152.
 */
package jmaster.jumploader.view.impl.upload.list;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import jmaster.jumploader.model.api.IModel;
import jmaster.jumploader.model.api.config.UploaderConfig;
import jmaster.jumploader.model.api.config.ViewConfig;
import jmaster.jumploader.model.api.upload.B;
import jmaster.jumploader.model.api.upload.IUploadFile;
import jmaster.jumploader.model.api.upload.IUploader;
import jmaster.jumploader.view.api.main.IMainView;
import jmaster.jumploader.view.impl.upload.list.IUploadFileListListener;
import jmaster.jumploader.view.impl.upload.list.UploadFileListCellRenderer;
import jmaster.jumploader.view.impl.upload.list.UploadFileListModel;
import jmaster.jumploader.view.impl.upload.list.dnd.FileDropListener;
import jmaster.jumploader.view.impl.upload.list.dnd.IFileDropTarget;
import jmaster.jumploader.view.impl.upload.list.dnd.UploadFileListTransferHandler;
import jmaster.jumploader.view.impl.upload.list.dnd.UploadFileTransferable;
import jmaster.util.B.A;
import jmaster.util.B.C;
import jmaster.util.lang.RunnableInfo;
import jmaster.util.swing.easylist.EasyList;

public class UploadFileList
extends EasyList
implements B,
Runnable,
IFileDropTarget,
KeyListener {
    private static final long \u016b = 9017089770972464908L;
    private static final String \u016e = "uploadFileList";
    private static final String \u0174 = "uploadFileListUpdater";
    private static final long \u016d = 500L;
    private IUploader \u0170;
    protected A \u0172 = new A(IUploadFileListListener.class);
    private UploadFileListModel \u016f;
    private long \u016c = 500L;
    private DropTarget \u016a;
    private int \u0177 = -1;
    private Icon \u0175;
    private ViewConfig \u0171;
    private IMainView \u0173;
    private UploaderConfig \u0176;

    public UploadFileList(IModel iModel, IMainView iMainView) {
        this.\u0173 = iMainView;
        this.\u0171 = iModel.getViewConfig();
        this.\u0176 = iModel.getUploaderConfig();
        this.setModel(new UploadFileListModel(iModel));
        this.\u0170 = iModel.getUploader();
        this.\u016f = (UploadFileListModel)super.getModel();
        this.\u00f2 = new UploadFileListCellRenderer(iModel, iMainView);
        this.setCellRenderer((ListCellRenderer)this.\u00f2);
        this.setLayoutOrientation(2);
        String string = \u016e + (this.\u0171.getUploadListViewName() == null ? "" : this.\u0171.getUploadListViewName());
        this.\u00f1.injectProperties(this, string);
        this.\u00f1.injectProperties(this.\u00ee, string, "emptyListLabel");
        this.addKeyListener(this);
        this.\u0170.addListener(this);
        this.addKeyListener(this);
        this.setTransferHandler(new UploadFileListTransferHandler());
        this.setDragEnabled(iModel.getUploaderConfig().isUploadQueueReorderingAllowed());
        this.\u016a = new DropTarget();
        this.setDropTarget(this.\u016a);
        this.\u016a.setComponent(this);
        this.\u016a.setActive(this.\u0170.isFileAdditionEnabled());
        try {
            this.\u016a.addDropTargetListener(new FileDropListener(this));
        }
        catch (TooManyListenersException tooManyListenersException) {
            tooManyListenersException.printStackTrace();
        }
        RunnableInfo runnableInfo = new RunnableInfo();
        runnableInfo.setRunnable(this);
        runnableInfo.setName(\u0174);
        runnableInfo.setDaemon(true);
        runnableInfo.setAutostart(true);
        iModel.getThreadManager().createThread(runnableInfo);
        this.updateView();
    }

    public long getUpdateInterval() {
        return this.\u016c;
    }

    public void setUpdateInterval(long l) {
        this.\u016c = l;
    }

    public Icon getInsertIcon() {
        return this.\u0175;
    }

    public void setInsertIcon(Icon icon) {
        this.\u0175 = icon;
    }

    public void addListener(IUploadFileListListener iUploadFileListListener) {
        this.\u0172.C(iUploadFileListListener);
    }

    public void removeListener(IUploadFileListListener iUploadFileListListener) {
        this.\u0172.A(iUploadFileListListener);
    }

    private void D(IUploadFile[] iUploadFileArray) {
        for (int k = 0; k < this.\u0172.C(); ++k) {
            IUploadFileListListener iUploadFileListListener = (IUploadFileListListener)this.\u0172.A(k);
            iUploadFileListListener.uflRemoveFilesAction(this, iUploadFileArray);
        }
    }

    private void C(String[] stringArray) {
        for (int k = 0; k < this.\u0172.C(); ++k) {
            IUploadFileListListener iUploadFileListListener = (IUploadFileListListener)this.\u0172.A(k);
            iUploadFileListListener.uflAddFilesAction(this, stringArray);
        }
    }

    public void uploaderFileAdditionEnabledChanged(IUploader iUploader) {
        this.\u016a.setActive(iUploader.isFileAdditionEnabled());
    }

    public void uploaderFileRemovalEnabledChanged(IUploader iUploader) {
    }

    public void uploaderFileAdded(IUploader iUploader, IUploadFile iUploadFile) {
        this.updateView();
    }

    public void uploaderFileRemoved(IUploader iUploader, IUploadFile iUploadFile) {
        this.updateView();
    }

    public void uploaderFileMoved(IUploader iUploader, IUploadFile iUploadFile, int n) {
        this.updateView();
    }

    public void uploaderFileStatusChanged(IUploader iUploader, IUploadFile iUploadFile) {
        if (this.\u0171.isUploadViewAutoscrollToUploadingFile() && iUploadFile.isUploading()) {
            this.scrollToFile(iUploadFile);
        }
    }

    public void uploaderFilesReset(IUploader iUploader) {
        this.updateView();
    }

    public void uploaderStatusChanged(IUploader iUploader) {
    }

    public void uploaderUploadEnabledChanged(IUploader iUploader) {
    }

    public void uploaderFileAddFailed(IUploader iUploader, jmaster.jumploader.model.api.A.C c2) {
    }

    public void uploaderFileUpdated(IUploader iUploader, IUploadFile iUploadFile) {
        this.updateView();
    }

    public void uploaderFilePartitionUploaded(IUploader iUploader, IUploadFile iUploadFile) {
    }

    public void uploaderPasteEnabledChanged(IUploader iUploader) {
    }

    public void run() {
        while (!this.\u0170.isDestroyed() && !Thread.currentThread().isInterrupted()) {
            this.updateUploadingCells();
            try {
                Thread.sleep(this.\u016c);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!keyEvent.isConsumed()) {
            IUploadFile[] iUploadFileArray;
            if (keyEvent.getKeyCode() == 127 && (iUploadFileArray = this.getSelectedFiles()) != null) {
                this.D(iUploadFileArray);
                keyEvent.consume();
            }
            if (keyEvent.getKeyCode() == 65487 || keyEvent.getKeyCode() == 86) {
                this.\u0170.pasteFromClipboard();
                keyEvent.consume();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.\u0177 != -1) {
            this.\u0177 = -1;
            this.repaint();
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(UploadFileTransferable.getDataFlavor())) {
            Rectangle rectangle;
            int n = 0;
            Point point = dropTargetDragEvent.getLocation();
            int n2 = this.getCellAtLocation(point);
            if (n2 == -1) {
                rectangle = this.getVisibleRect();
                while (n2 == -1 && rectangle.contains(point)) {
                    n2 = this.getCellAtLocation(point);
                    --point.x;
                }
            }
            n = n2 != -1 ? ((rectangle = this.getCellBounds(n2, n2)).getCenterX() > (double)point.x ? n2 : n2 + 1) : this.getModel().getSize();
            if (n != this.\u0177) {
                this.\u0177 = n;
                this.\u00ef.D("cell=" + n2 + ", insertIndex=" + this.\u0177);
                this.repaint();
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (this.\u0177 != -1) {
            this.\u0177 = -1;
            this.repaint();
        }
    }

    public void filesDropped(File[] fileArray) {
        if (this.\u0177 != -1) {
            this.\u0177 = -1;
            this.repaint();
        }
        String[] stringArray = new String[fileArray.length];
        for (int k = 0; k < fileArray.length; ++k) {
            stringArray[k] = fileArray[k].getAbsolutePath();
        }
        this.C(stringArray);
    }

    public void textDropped(String string) {
        if (this.\u0176 != null && this.\u0176.isClipboardTextEnabled()) {
            try {
                this.\u0170.addText(string);
            }
            catch (jmaster.jumploader.model.api.A.C c2) {
                c2.printStackTrace();
            }
        }
    }

    public void moveFiles(IUploadFile[] iUploadFileArray) {
        try {
            C.C(this.\u0170, "moveFiles", new Class[]{IUploadFile[].class, Integer.TYPE}, new Object[]{iUploadFileArray, new Integer(this.\u0177)});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.\u0177 != -1) {
            this.\u0177 = -1;
            this.repaint();
        }
    }

    public void updateUploadingCells() {
        if (!C.A()) {
            C.E(this, "updateUploadingCells");
            return;
        }
        for (int k = 0; k < this.\u016f.getSize(); ++k) {
            IUploadFile iUploadFile = this.\u016f.getUploadFile(k);
            if (!iUploadFile.isDownloading() && !iUploadFile.isUploading() && !iUploadFile.isPreprocessing() && !iUploadFile.isServerProcessing()) continue;
            this.repaintCell(k);
        }
    }

    public IUploadFile[] getSelectedFiles() {
        IUploadFile[] iUploadFileArray = null;
        int[] nArray = this.getSelectedIndices();
        if (nArray != null && nArray.length > 0) {
            iUploadFileArray = new IUploadFile[nArray.length];
            for (int k = 0; k < nArray.length; ++k) {
                iUploadFileArray[k] = this.\u016f.getUploadFile(nArray[k]);
            }
        }
        return iUploadFileArray;
    }

    public void updateView() {
        if (!C.A()) {
            C.B(this);
            return;
        }
        this.setBackgroundVisible(this.getModel().getSize() == 0);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.\u0177 != -1 && this.\u0175 != null) {
            Rectangle rectangle = null;
            int n = 0;
            int n2 = 0;
            if (this.\u0177 < this.\u016f.getSize()) {
                rectangle = this.getCellBounds(this.\u0177, this.\u0177);
                n = rectangle.x - this.\u0175.getIconWidth() / 2;
                n2 = rectangle.y + rectangle.height / 2 - this.\u0175.getIconHeight() / 2;
            } else {
                rectangle = this.getCellBounds(this.\u016f.getSize() - 1, this.\u016f.getSize() - 1);
                n = rectangle.x + rectangle.width - this.\u0175.getIconWidth() / 2;
                n2 = rectangle.y + rectangle.height / 2 - this.\u0175.getIconHeight() / 2;
            }
            this.\u00ef.D("i=" + this.\u0177 + ", x=" + n + ", y=" + n2 + ", b=" + rectangle);
            this.\u0175.paintIcon(this, graphics, n, n2);
            int n3 = -1;
            int n4 = -1;
            if (this.\u0177 > 0 && this.\u0177 < this.\u016f.getSize()) {
                rectangle = this.getCellBounds(this.\u0177 - 1, this.\u0177 - 1);
                n3 = rectangle.x + rectangle.width - this.\u0175.getIconWidth() / 2;
                n4 = rectangle.y + rectangle.height / 2 - this.\u0175.getIconHeight() / 2;
            }
            if (n3 != -1 && n4 != -1 && n != n3 && n2 != n4) {
                this.\u0175.paintIcon(this, graphics, n3, n4);
            }
        }
    }

    private boolean p() {
        boolean bl = false;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(DataFlavor.javaFileListFlavor)) {
            try {
                Object object = clipboard.getData(DataFlavor.javaFileListFlavor);
                List list = (List)object;
                File[] fileArray = new File[list.size()];
                for (int k = 0; k < list.size(); ++k) {
                    fileArray[k] = (File)list.get(k);
                }
                this.filesDropped(fileArray);
                bl = true;
            }
            catch (Exception exception) {
                this.\u00ef.E("Failed to get clipboard data", exception);
            }
        }
        return bl;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (this.\u0171.isUploadViewListShowAddDialogOnDblClick() && mouseEvent.getClickCount() == 2 && this.getCellAtLocation(mouseEvent.getPoint()) == -1) {
            this.\u0173.getUploadView().showOpenDialog();
        }
    }

    public void scrollToFile(IUploadFile iUploadFile) {
        if (!C.A()) {
            C.B(this, "scrollToFile", new Class[]{IUploadFile.class}, new Object[]{iUploadFile});
            return;
        }
        int n = this.\u016f.indexOfItem(iUploadFile);
        if (n != -1) {
            Rectangle rectangle = this.getCellBounds(n, n);
            this.scrollRectToVisible(rectangle);
        }
    }
}

