/*
 * Decompiled with CFR 0.152.
 */
package jmaster.jumploader.model.impl.upload;

import java.io.File;
import java.util.regex.Pattern;
import jmaster.jumploader.app.ShutdownCleaner;
import jmaster.jumploader.model.api.IModel;
import jmaster.jumploader.model.api.config.UploaderConfig;
import jmaster.jumploader.model.api.upload.IUploadFile;
import jmaster.jumploader.model.api.upload.IUploader;
import jmaster.jumploader.model.impl.upload.C;
import jmaster.util.lang.MutableLong;
import jmaster.util.log.A;
import jmaster.util.log.B;

public class UploadFilePreprocessor
implements jmaster.jumploader.model.api.upload.B {
    protected A \u015f = B.getInstance().getLog(this.getClass());
    private IModel \u015e;

    public UploadFilePreprocessor(IModel iModel) {
        this.\u015e = iModel;
        iModel.getUploader().addListener(this);
    }

    public void uploaderFileAddFailed(IUploader iUploader, jmaster.jumploader.model.api.A.C c2) {
    }

    public void uploaderFileAdded(IUploader iUploader, IUploadFile iUploadFile) {
        UploaderConfig uploaderConfig = this.\u015e.getUploaderConfig();
        if (iUploadFile.isFile() && "zipOnAdd".equals(uploaderConfig.getCompressionMode())) {
            if (uploaderConfig.getSkipZippingFilesPattern() != null && Pattern.matches(uploaderConfig.getSkipZippingFilesPattern(), iUploadFile.getName())) {
                return;
            }
            this.\u015e.getUploader().updateFileStatus(iUploadFile, 4);
            jmaster.util.B.C.C(this, "zipFile", new Class[]{IUploader.class, C.class}, new Object[]{iUploader, iUploadFile});
        }
        if (iUploadFile.isDirectory() && uploaderConfig.isZipDirectoriesOnAdd()) {
            this.\u015e.getUploader().updateFileStatus(iUploadFile, 4);
            jmaster.util.B.C.C(this, "zipDirectory", new Class[]{IUploader.class, C.class}, new Object[]{iUploader, iUploadFile});
        }
    }

    public void uploaderFileAdditionEnabledChanged(IUploader iUploader) {
    }

    public void uploaderFileMoved(IUploader iUploader, IUploadFile iUploadFile, int n) {
    }

    public void uploaderFileRemovalEnabledChanged(IUploader iUploader) {
    }

    public void uploaderFileRemoved(IUploader iUploader, IUploadFile iUploadFile) {
    }

    public void uploaderFileStatusChanged(IUploader iUploader, IUploadFile iUploadFile) {
    }

    public void uploaderFileUpdated(IUploader iUploader, IUploadFile iUploadFile) {
    }

    public void uploaderFilesReset(IUploader iUploader) {
    }

    public void uploaderStatusChanged(IUploader iUploader) {
    }

    public void uploaderUploadEnabledChanged(IUploader iUploader) {
    }

    public void uploaderFilePartitionUploaded(IUploader iUploader, IUploadFile iUploadFile) {
    }

    public void uploaderPasteEnabledChanged(IUploader iUploader) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipFile(IUploader iUploader, C c2) {
        this.\u015f.D("Preprocessing " + c2);
        try {
            this.\u015e.getUploader().updateFileStatus(c2, 4);
            long l = c2.getLength();
            File file = File.createTempFile("jumploader", ".zip");
            ShutdownCleaner.getInstance().addFile(file);
            jmaster.util.E.A.A a2 = jmaster.util.E.A.B.A(this.\u015e).A();
            a2.zipFile(this.\u015e, c2.getPath(), file.getAbsolutePath(), null, null);
            c2.A(file, true);
            if (l > 0L) {
                c2.A(new Double((double)file.length() / (double)l));
            }
            c2.A(c2.getName() + ".zip");
            c2.G(true);
        }
        catch (Exception exception) {
            this.\u015f.E(exception, exception);
        }
        finally {
            iUploader.updateFileStatus(c2, 0);
            this.\u015f.D("Preprocessing finished for " + c2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipDirectory(IUploader iUploader, C c2) {
        this.\u015f.D("Preprocessing " + c2);
        try {
            this.\u015e.getUploader().updateFileStatus(c2, 4);
            File file = File.createTempFile("jumploader", ".zip");
            ShutdownCleaner.getInstance().addFile(file);
            MutableLong mutableLong = new MutableLong();
            jmaster.util.E.A.A a2 = jmaster.util.E.A.B.A(this.\u015e).A();
            a2.zipFolder(this.\u015e, c2.getPath(), file.getAbsolutePath(), mutableLong, this.\u015e.getUploaderConfig().getZipFileFilter());
            c2.A(file, true, true);
            if (mutableLong.getValue() > 0L) {
                c2.A(new Double((double)file.length() / (double)mutableLong.getValue()));
            }
            c2.A(c2.getName() + ".zip");
            c2.G(true);
            c2.getAttributeSet().setStringAttribute("zippedDirectory", "true");
        }
        catch (Exception exception) {
            this.\u015f.E(exception, exception);
        }
        finally {
            iUploader.updateFileStatus(c2, 0);
            this.\u015f.D("Preprocessing finished for " + c2);
        }
    }

    public void destroy() {
    }
}

