/*
 * Decompiled with CFR 0.152.
 */
package jmaster.util.lang.process.impl;

import java.util.Date;
import jmaster.util.lang.CodeException;
import jmaster.util.lang.LangHelper;
import jmaster.util.lang.bean.impl.GenericBean;
import jmaster.util.lang.process.IProcess;
import jmaster.util.lang.value.IValueProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericProcess
extends GenericBean
implements IProcess {
    private String \u025a = "ready";
    private String \u0253;
    protected String \u025f;
    protected String \u0255;
    protected boolean \u0254 = false;
    protected boolean \u0259 = false;
    protected boolean \u025b = false;
    protected boolean \u025d = false;
    protected boolean \u0261 = false;
    protected Object \u0262;
    protected Runnable \u0260;
    protected Exception \u025e;
    protected float \u0257 = -1.0f;
    protected IValueProvider<Float> \u0256;
    protected Date \u0258;
    protected Date \u025c;

    @Override
    public boolean isCancellable() {
        return this.\u0259;
    }

    public void setCancellable(boolean bl) {
        this.\u0259 = bl;
    }

    @Override
    public boolean isPausable() {
        return this.\u025b;
    }

    public void setPausable(boolean bl) {
        this.\u025b = bl;
    }

    @Override
    public boolean isCancelled() {
        return this.\u025d;
    }

    public void setCancelled(boolean bl) {
        this.\u025d = bl;
    }

    @Override
    public Exception getError() {
        return this.\u025e;
    }

    public void setError(Exception exception) {
        this.\u025e = exception;
    }

    @Override
    public String getId() {
        return this.\u0253;
    }

    public void setId(String string) {
        this.\u0253 = string;
    }

    @Override
    public String getDescription() {
        return this.\u025f;
    }

    public void setDescription(String string) {
        this.\u025f = string;
    }

    @Override
    public float getCompletion() {
        return this.\u0256 == null ? this.\u0257 : this.\u0256.getValue().floatValue();
    }

    public void setCompletion(float f2) {
        this.\u0257 = f2;
    }

    @Override
    public String getStatus() {
        return this.\u025a;
    }

    @Override
    public boolean isRestartable() {
        return this.\u0254;
    }

    public void setRestartable(boolean bl) {
        this.\u0254 = bl;
    }

    @Override
    public String getTaskDescription() {
        return this.\u0255;
    }

    public void setTaskDescription(String string) {
        this.\u0255 = string;
    }

    public IValueProvider<Float> getCompletionValueProvider() {
        return this.\u0256;
    }

    public void setCompletionValueProvider(IValueProvider<Float> iValueProvider) {
        this.\u0256 = iValueProvider;
    }

    public Runnable getCancelCallback() {
        return this.\u0260;
    }

    public void setCancelCallback(Runnable runnable) {
        this.\u0260 = runnable;
    }

    public void updateStatus(String string) {
        if (!LangHelper.equals(this.\u025a, string)) {
            this.\u025a = string;
            this.C(EVENT_PROCESS_STATUS_CHANGED, this);
        }
    }

    @Override
    public boolean canCancel() {
        return this.\u0259 && (this.isRunning() || this.isPaused());
    }

    @Override
    public boolean canPause() {
        return this.\u025b && this.isRunning();
    }

    @Override
    public boolean canResume() {
        return this.isPaused();
    }

    @Override
    public boolean isPaused() {
        return "paused".equals(this.\u025a);
    }

    @Override
    public boolean isReady() {
        return "ready".equals(this.\u025a);
    }

    @Override
    public boolean isRunning() {
        return "running".equals(this.\u025a);
    }

    @Override
    public boolean isTerminated() {
        return "terminated".equals(this.\u025a);
    }

    @Override
    public boolean canRun() {
        return "ready".equals(this.\u025a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object run() {
        if (!this.canRun()) {
            LangHelper.throwRuntime("Unable to start " + this);
        }
        try {
            this.start();
            this.\u0262 = this.\u00cb();
            this.\u025c = new Date();
            this.updateStatus(this.\u0254 ? "ready" : "terminated");
        }
        catch (Exception exception) {
            try {
                this.\u025e = exception;
                this.\u025c = new Date();
                this.updateStatus(this.\u0254 ? "ready" : "terminated");
            }
            catch (Throwable throwable) {
                this.\u025c = new Date();
                this.updateStatus(this.\u0254 ? "ready" : "terminated");
                throw throwable;
            }
        }
        return this.\u0262;
    }

    public void start() throws Exception {
        this.\u0257 = -1.0f;
        this.\u025e = null;
        this.\u0258 = new Date();
        this.\u025c = null;
        this.\u025d = false;
        this.\u0261 = false;
        this.\u00cf();
        this.updateStatus("running");
    }

    public void stop() {
        this.\u025c = new Date();
        this.updateStatus("terminated");
    }

    @Override
    public final void pause() {
        if (!this.canPause()) {
            LangHelper.throwRuntime("Unable to pause " + this);
        }
        this.\u0261 = true;
        this.\u00cc();
        this.updateStatus("paused");
    }

    @Override
    public final void resume() {
        if (!this.canResume()) {
            LangHelper.throwRuntime("Unable to resume " + this);
        }
        this.\u0261 = false;
        this.\u00cd();
        this.updateStatus("running");
    }

    @Override
    public final void cancel() {
        if (!this.canCancel()) {
            LangHelper.throwRuntime("Unable to cancel " + this);
        }
        this.\u025d = true;
        if (this.\u0260 != null) {
            this.\u0260.run();
        }
        this.\u00ce();
        this.updateStatus(this.\u0254 ? "ready" : "terminated");
    }

    protected void \u00cf() throws Exception {
    }

    protected Object \u00cb() throws Exception {
        while (this.isRunning() || this.isPaused()) {
            Thread.sleep(100L);
        }
        return null;
    }

    protected void \u00cc() {
    }

    protected void \u00cd() {
    }

    protected void \u00ce() {
    }

    @Override
    public long getElapsedTime() {
        return this.isRunning() || this.isPaused() ? System.currentTimeMillis() - this.\u0258.getTime() : -1L;
    }

    @Override
    public long getEstimatedTimeLeft() {
        return this.isRunning() ? this.\u00d0() : -1L;
    }

    protected long \u00d0() {
        long l2 = -1L;
        if (this.\u0257 >= 0.0f) {
            l2 = this.\u0257 == 1.0f ? 0L : (long)((float)this.getElapsedTime() * (1.0f - this.\u0257) / this.\u0257);
        }
        return l2;
    }

    @Override
    public void destroy() {
        if (this.isRunning() || this.isPaused()) {
            this.cancel();
        }
        super.destroy();
    }

    @Override
    public void init() {
        super.init();
    }

    public void checkStatus() throws InterruptedException {
        if (this.isCancelled()) {
            throw new CodeException("Aborted by user", IProcess.ERROR_CODE_CANCELLED);
        }
        while (this.isPaused()) {
            Thread.sleep(100L);
        }
    }
}

