/*
 * Decompiled with CFR 0.152.
 */
package jmaster.util.lang.list.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import jmaster.util.lang.LangHelper;
import jmaster.util.lang.bean.impl.GenericBean;
import jmaster.util.lang.list.IList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListImpl<E>
extends GenericBean
implements IList<E> {
    private List<E> \u0250 = new ArrayList();
    private E \u0252;
    private boolean \u0251 = true;

    public List<E> getDelegate() {
        return this.\u0250;
    }

    public void setDelegate(List<E> list) {
        this.\u0250 = list;
    }

    public boolean isDuplicatesAllowed() {
        return this.\u0251;
    }

    public void setDuplicatesAllowed(boolean bl) {
        this.\u0251 = bl;
    }

    @Override
    public E getSelectedElement() {
        return this.\u0252;
    }

    public void removeAllElements() {
        this.\u0250.clear();
        this.M(EVENT_LIST_ALL_ELEMENTS_REMOVED);
    }

    public void removeElement(E e2) {
        this.removeElementAt(this.indexOf(e2));
    }

    public void removeElementAt(int n2) {
        E e2 = this.\u0250.remove(n2);
        this.C(EVENT_LIST_ELEMENT_REMOVED, e2, n2);
    }

    @Override
    public void setSelectedElement(E e2) {
        this.assertContains(e2);
        if (!LangHelper.equals(this.\u0252, e2)) {
            this.\u0252 = e2;
            this.C(EVENT_LIST_SELECTED_ELEMENT_CHANGED, e2, this.indexOf(e2));
        }
    }

    public void setSelectedIndex(int n2) {
        this.setSelectedElement(this.get(n2));
    }

    public void elementUpdated(E e2) {
        this.C(EVENT_LIST_ELEMENT_UPDATED, e2, this.indexOf(e2));
    }

    public void elementUpdatedAt(int n2) {
        this.C(EVENT_LIST_ELEMENT_UPDATED, this.get(n2), n2);
    }

    public void assertContains(E e2) {
        if (!this.contains(e2)) {
            throw new RuntimeException("Element not in list: " + e2);
        }
    }

    public void assertNotContains(E e2) {
        if (this.contains(e2)) {
            throw new RuntimeException("Element is in list: " + e2);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.\u0250.isEmpty();
    }

    @Override
    public boolean add(E e2) {
        if (!this.\u0251) {
            this.assertNotContains(e2);
        }
        boolean bl = this.\u0250.add(e2);
        int n2 = this.indexOf(e2);
        this.C(EVENT_LIST_ELEMENT_ADDED, e2, n2);
        return bl;
    }

    @Override
    public void add(int n2, E e2) {
        if (!this.\u0251) {
            this.assertNotContains(e2);
        }
        this.\u0250.add(n2, e2);
        this.C(EVENT_LIST_ELEMENT_ADDED, e2, n2);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        for (E e2 : collection) {
            this.add(e2);
        }
        return collection.size() > 0;
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        int n3 = n2;
        for (E e2 : collection) {
            this.add(n3, e2);
        }
        return collection.size() > 0;
    }

    @Override
    public void clear() {
        this.\u0250.clear();
        this.M(EVENT_LIST_ALL_ELEMENTS_REMOVED);
    }

    @Override
    public boolean contains(Object object) {
        return this.\u0250.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.\u0250.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        return ((Object)this.\u0250).equals(object);
    }

    @Override
    public E get(int n2) {
        return this.\u0250.get(n2);
    }

    @Override
    public int hashCode() {
        return ((Object)this.\u0250).hashCode();
    }

    @Override
    public int indexOf(Object object) {
        return this.\u0250.indexOf(object);
    }

    @Override
    public Iterator<E> iterator() {
        return this.\u0250.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.\u0250.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.\u0250.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int n2) {
        return this.\u0250.listIterator(n2);
    }

    @Override
    public E remove(int n2) {
        E e2 = this.\u0250.remove(n2);
        this.C(EVENT_LIST_ELEMENT_REMOVED, e2, n2);
        return e2;
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = false;
        int n2 = this.indexOf(object);
        if (n2 >= 0) {
            bl = this.\u0250.remove(object);
            this.C(EVENT_LIST_ELEMENT_REMOVED, object, n2);
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        if (collection != null) {
            for (Object obj : collection) {
                bl |= this.remove(obj);
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        if (collection == null || collection.size() == 0) {
            this.clear();
            bl = true;
        } else {
            for (int i2 = this.size() - 1; i2 >= 0; --i2) {
                E e2 = this.get(i2);
                if (collection.contains(e2)) continue;
                this.remove(i2);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public E set(int n2, E e2) {
        E e3 = this.\u0250.set(n2, e2);
        this.C(EVENT_LIST_ELEMENT_REPLACED, e2, n2, e3);
        return e3;
    }

    @Override
    public int size() {
        return this.\u0250.size();
    }

    @Override
    public List<E> subList(int n2, int n3) {
        return this.\u0250.subList(n2, n3);
    }

    @Override
    public Object[] toArray() {
        return this.\u0250.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.\u0250.toArray(TArray);
    }

    @Override
    public void addAll(E[] EArray) {
        if (EArray != null) {
            List<E> list = Arrays.asList(EArray);
            this.addAll(list);
        }
    }

    @Override
    public void reset(E[] EArray) {
        this.clear();
        this.addAll(EArray);
    }

    @Override
    public void reset(List<E> list) {
        this.clear();
        this.addAll(list);
    }
}

