/*
 * Decompiled with CFR 0.152.
 */
package jmaster.util.lang;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LangHelper {
    public static final long MS_IN_DAY = 86400000L;

    public static void handleRuntime(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RuntimeException(throwable);
    }

    public static void handleRuntime(Exception exception) {
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    public static void throwRuntime(String string) {
        throw new RuntimeException(string);
    }

    public static void throwRuntime(String string, Exception exception) {
        throw new RuntimeException(string, exception);
    }

    public static void throwNotImplemented() {
        LangHelper.throwRuntime("Not implemented");
    }

    public static Map toMap(List list, String string) {
        HashMap hashMap = new HashMap();
        if (list != null) {
            try {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    Object e2 = list.get(i2);
                    Method method = e2.getClass().getMethod(string, null);
                    Object object = method.invoke(e2, (Object[])null);
                    hashMap.put(object, e2);
                }
            }
            catch (Exception exception) {
                LangHelper.handleRuntime(exception);
            }
        }
        return hashMap;
    }

    public static String toString(Collection collection, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        Iterator iterator = collection.iterator();
        while (iterator != null && iterator.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append("" + n2++ + ". ");
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    public static String toString(Object[] objectArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                stringBuffer.append(string);
                stringBuffer.append("" + i2 + ". ");
                stringBuffer.append(objectArray[i2]);
            }
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    public static Object toArray(List list, Class clazz) {
        Object object = null;
        if (list != null) {
            object = Array.newInstance(clazz, list.size());
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Array.set(object, i2, list.get(i2));
            }
        }
        return object;
    }

    public static Object toArray(List list) {
        return LangHelper.isEmpty(list) ? null : LangHelper.toArray(list, list.get(0).getClass());
    }

    public static Object toArray(Object[] objectArray, Class clazz) {
        Object object = null;
        if (objectArray != null) {
            object = Array.newInstance(clazz, objectArray.length);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Array.set(object, i2, objectArray[i2]);
            }
        }
        return object;
    }

    public static int indexOf(Object[] objectArray, Object object) {
        int n2 = -1;
        if (object != null && objectArray != null) {
            for (int i2 = objectArray.length - 1; i2 >= 0 && n2 == -1; --i2) {
                if (!object.equals(objectArray[i2])) continue;
                n2 = i2;
            }
        }
        return n2;
    }

    public static boolean equals(Object object, Object object2) {
        boolean bl = false;
        if (object == null && object2 == null) {
            bl = true;
        } else if (object != null && object2 != null) {
            bl = object.equals(object2);
        }
        return bl;
    }

    public static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    public static boolean isEmpty(List list) {
        return list == null || list.size() == 0;
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable throwable2 = throwable;
        while (throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        return throwable2;
    }

    public static void throwNotAllowed() {
        throw new RuntimeException("Not allowed");
    }

    public static void throwIfRuntime(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
    }

    public static Object nvl(Object ... objectArray) {
        Object object = null;
        int n2 = 0;
        while (object == null && objectArray != null && n2 < objectArray.length) {
            object = objectArray[n2++];
        }
        return object;
    }

    public static Object instanceOf(Class<?> clazz, Object object) {
        return object != null && clazz.isAssignableFrom(object.getClass()) ? object : null;
    }

    public static Map toMap(Object ... objectArray) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(objectArray.length * 2);
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            hashMap.put(objectArray[i2], objectArray[i2 + 1]);
        }
        return hashMap;
    }

    public static List toList(Object ... objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            arrayList.add(objectArray[i2]);
        }
        return arrayList;
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.size() == 0;
    }
}

