/*
 * Decompiled with CFR 0.152.
 */
package jmaster.jumploader.view.impl.image;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import jmaster.jumploader.model.api.IModel;
import jmaster.jumploader.model.api.config.ImageConfig;
import jmaster.jumploader.view.impl.image.CropRatioItem;
import jmaster.jumploader.view.impl.image.ImageControlListener;
import jmaster.jumploader.view.impl.image.ImageView;
import jmaster.jumploader.view.impl.image.RectangleRubberBand;
import jmaster.util.swing.GUIHelper;

public class ImageControl
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final long D = -6171717419492647594L;
    public static final String PREFIX = "imageControl";
    public static final int MODE_DEFAULT = 0;
    public static final int MODE_COLOR_SELECT = 1;
    protected GUIHelper N = GUIHelper.getInstance();
    protected IModel B;
    protected Vector L = new Vector();
    protected RectangleRubberBand I;
    protected Double M = null;
    protected Integer Q = null;
    protected Integer A = null;
    protected JLabel O = new JLabel();
    protected BufferedImage K;
    protected int F;
    protected int P;
    protected double C = 1.0;
    protected Point J = null;
    protected boolean E = false;
    protected Image R;
    protected int G = 0;
    protected Color H;

    public ImageControl(IModel iModel) {
        this.B = iModel;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.N.injectProperties(this, PREFIX);
        this.N.injectProperties(this.O, PREFIX, "emptyControlLabel");
        this.O.setHorizontalAlignment(0);
    }

    public void init() {
        this.init(true);
    }

    public void init(boolean bl) {
        this.setPreferredSize(new Dimension((int)((double)this.F * this.C), (int)((double)this.P * this.C)));
        if (bl) {
            this.I = null;
            this.B((RectangleRubberBand)null);
        }
        this.revalidate();
        this.repaint();
    }

    public void addImageControlListener(ImageControlListener imageControlListener) {
        this.L.add(imageControlListener);
    }

    public void removeImageControlListener(ImageControlListener imageControlListener) {
        this.L.remove(imageControlListener);
    }

    private void B(RectangleRubberBand rectangleRubberBand) {
        for (ImageControlListener imageControlListener : this.L) {
            imageControlListener.rectangleRubberBandChanged(this, rectangleRubberBand);
        }
    }

    private void A(Color color) {
        for (ImageControlListener imageControlListener : this.L) {
            imageControlListener.selectedColorChanged(this, color);
        }
    }

    public int getMode() {
        return this.G;
    }

    public void setMode(int n2) {
        this.G = n2;
        switch (n2) {
            case 0: {
                this.setCursor(new Cursor(0));
                break;
            }
            case 1: {
                this.setCursor(new Cursor(1));
            }
        }
    }

    public BufferedImage getImage() {
        return this.K;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.K = bufferedImage;
        if (bufferedImage != null) {
            this.F = bufferedImage.getWidth();
            this.P = bufferedImage.getHeight();
        } else {
            this.F = 0;
            this.P = 0;
        }
        this.init();
    }

    public void discardImage() {
        this.K = null;
        this.F = 0;
        this.P = 0;
        this.init();
    }

    public double getZoomFactor() {
        return this.C;
    }

    public void setZoomFactor(double d2) {
        this.C = d2;
        this.init(false);
    }

    public int getImageHeight() {
        return this.P;
    }

    public int getImageWidth() {
        return this.F;
    }

    public RectangleRubberBand getBand() {
        return this.I;
    }

    public void setBandCoords(int n2, int n3, int n4, int n5) {
        if (this.I == null) {
            this.I = this.A();
        } else {
            this.A(this.I);
        }
        n2 = this.A(n2);
        n4 = this.A(n4);
        n3 = this.B(n3);
        n5 = this.B(n5);
        this.I.setCoords(Math.min(n2, n4), Math.min(n3, n5), Math.max(n2, n4), Math.max(n3, n5));
        this.A(this.I);
    }

    private int A(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > this.F - 1) {
            n2 = this.F - 1;
        }
        return n2;
    }

    private int B(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > this.P - 1) {
            n2 = this.P - 1;
        }
        return n2;
    }

    public boolean isWaitMode() {
        return this.E;
    }

    public void setWaitMode(boolean bl) {
        this.E = bl;
    }

    public Image getWaitImage() {
        return this.R;
    }

    public void setWaitImage(Image image) {
        this.R = image;
    }

    public Integer getBandPerimeterMax() {
        return this.A;
    }

    public void setBandPerimeterMax(Integer n2) {
        this.A = n2;
    }

    public Integer getBandPerimeterMin() {
        return this.Q;
    }

    public void setBandPerimeterMin(Integer n2) {
        this.Q = n2;
    }

    public Double getBandProportions() {
        return this.M;
    }

    public void setBandProportions(Double d2) {
        this.M = d2;
    }

    public Color getSelectedColor() {
        return this.H;
    }

    public void setSelectedColor(Color color) {
        this.H = color;
        this.A(color);
    }

    public String getSelectedColorHex() {
        return this.H == null ? null : Integer.toHexString(this.H.getRGB()).substring(2);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.K != null) {
            graphics.drawImage(this.K, 0, 0, (int)((double)this.F * this.C), (int)((double)this.P * this.C), 0, 0, this.F, this.P, null);
            if (this.I != null) {
                this.A((Graphics2D)graphics, this.I);
            }
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.O.setBounds(this.getBounds());
            this.O.paint(graphics);
        }
    }

    protected void A(RectangleRubberBand rectangleRubberBand) {
        this.A(null, rectangleRubberBand);
    }

    protected synchronized void A(Graphics2D graphics2D, RectangleRubberBand rectangleRubberBand) {
        if (graphics2D == null) {
            graphics2D = (Graphics2D)this.getGraphics();
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.setXORMode(Color.WHITE);
        graphics2D.setStroke(RectangleRubberBand.O);
        Point point = this.imageToScreen(rectangleRubberBand.getLeftTop());
        Point point2 = this.imageToScreen(rectangleRubberBand.getRightBottom());
        point2.setLocation(point2.getX() + this.C - 1.0, point2.getY() + this.C - 1.0);
        double d2 = point2.getX() - point.getX();
        double d3 = point2.getY() - point.getY();
        graphics2D.drawRect((int)point.getX(), (int)point.getY(), (int)d2, (int)d3);
        graphics2D.setStroke(RectangleRubberBand.I);
        for (int i2 = 0; i2 < 8; ++i2) {
            int n2 = (int)(RectangleRubberBand.ANCHOR_X_FACTOR[i2] * d2 + point.getX() - 3.0);
            int n3 = (int)(RectangleRubberBand.ANCHOR_Y_FACTOR[i2] * d3 + point.getY() - 3.0);
            graphics2D.drawRect(n2, n3, 6, 6);
        }
    }

    public Point screenToImage(Point point) {
        int n2;
        int n3 = (int)(point.getX() / this.C);
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= this.F) {
            n3 = this.F - 1;
        }
        if ((n2 = (int)(point.getY() / this.C)) < 0) {
            n2 = 0;
        }
        if (n2 >= this.P) {
            n2 = this.P - 1;
        }
        return new Point(n3, n2);
    }

    public Point imageToScreen(Point point) {
        Point point2 = new Point();
        point2.setLocation(point.getX() * this.C, point.getY() * this.C);
        return point2;
    }

    public boolean isImagePoint(Point point) {
        return this.K != null && point.getX() >= 0.0 && point.getY() >= 0.0 && point.getX() < (double)this.F && point.getY() < (double)this.P;
    }

    public Rectangle getBandScreenRectangle(RectangleRubberBand rectangleRubberBand) {
        Point point = this.imageToScreen(rectangleRubberBand.getLeftTop());
        Point point2 = this.imageToScreen(rectangleRubberBand.getRightBottom());
        point2.setLocation(point2.getX() + this.C - 1.0, point2.getY() + this.C - 1.0);
        Rectangle rectangle = new Rectangle(point);
        rectangle.add(point2);
        return rectangle;
    }

    private boolean A(RectangleRubberBand rectangleRubberBand, Point point) {
        Rectangle rectangle = this.getBandScreenRectangle(rectangleRubberBand);
        return rectangle.contains(point);
    }

    private int B(RectangleRubberBand rectangleRubberBand, Point point) {
        int n2 = -1;
        for (int i2 = 0; i2 < 8; ++i2) {
            Rectangle rectangle = this.A(rectangleRubberBand, i2);
            if (!rectangle.contains(point)) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    private Rectangle A(RectangleRubberBand rectangleRubberBand, int n2) {
        Point point = this.imageToScreen(rectangleRubberBand.getLeftTop());
        Point point2 = this.imageToScreen(rectangleRubberBand.getRightBottom());
        point2.setLocation(point2.getX() + this.C - 1.0, point2.getY() + this.C - 1.0);
        double d2 = point2.getX() - point.getX();
        double d3 = point2.getY() - point.getY();
        int n3 = (int)(RectangleRubberBand.ANCHOR_X_FACTOR[n2] * d2 + point.getX() - 3.0);
        int n4 = (int)(RectangleRubberBand.ANCHOR_Y_FACTOR[n2] * d3 + point.getY() - 3.0);
        return new Rectangle(n3, n4, 6, 6);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        switch (this.G) {
            case 0: {
                this.D(mouseEvent);
                break;
            }
            case 1: {
                this.E(mouseEvent);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        switch (this.G) {
            case 0: {
                this.B(mouseEvent);
            }
        }
    }

    private void B(MouseEvent mouseEvent) {
        if (this.I != null) {
            this.I.setStatus(0);
            if (this.I.getWidth() == 0 && this.I.getHeight() == 0) {
                this.A(this.I);
                this.I = null;
            }
            this.B(this.I);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        switch (this.G) {
            case 0: {
                this.F(mouseEvent);
                break;
            }
            case 1: {
                this.C(mouseEvent);
            }
        }
    }

    private void C(MouseEvent mouseEvent) {
        Point point = this.screenToImage(mouseEvent.getPoint());
        this.setSelectedColor(new Color(this.K.getRGB(point.x, point.y)));
    }

    private void F(MouseEvent mouseEvent) {
        if (this.I != null && this.I.getStatus() != 0) {
            int n2;
            int n3;
            int n4 = this.I.getX0();
            int n5 = this.I.getY0();
            int n6 = this.I.getX1();
            int n7 = this.I.getY1();
            block0 : switch (this.I.getStatus()) {
                case 2: {
                    Point point = new Point((int)((double)mouseEvent.getX() - this.J.getX()), (int)((double)mouseEvent.getY() - this.J.getY()));
                    Point point2 = this.screenToImage(point);
                    n3 = (int)(point2.getY() + (double)this.I.getHeight() - 1.0);
                    for (n2 = (int)(point2.getX() + (double)this.I.getWidth() - 1.0); n2 >= this.F; --n2) {
                    }
                    while (n3 >= this.P) {
                        --n3;
                    }
                    point2.setLocation(n2 - this.I.getWidth() + 1, n3 - this.I.getHeight() + 1);
                    this.I.setPoint0(point2);
                    this.I.setPoint1(new Point(n2, n3));
                    break;
                }
                case 1: {
                    Point point = this.screenToImage(mouseEvent.getPoint());
                    switch (this.I.getHotAnchorId()) {
                        case 0: 
                        case 2: 
                        case 4: 
                        case 6: {
                            this.I.setPoint1(point);
                            break block0;
                        }
                        case 3: 
                        case 7: {
                            this.I.setX1((int)point.getX());
                            break block0;
                        }
                        case 1: 
                        case 5: {
                            this.I.setY1((int)point.getY());
                        }
                    }
                }
            }
            if (n4 != this.I.getX0() || n5 != this.I.getY0() || n6 != this.I.getX1() || n7 != this.I.getY1()) {
                int n8 = this.I.getX0();
                int n9 = this.I.getY0();
                n2 = this.I.getX1();
                n3 = this.I.getY1();
                this.I.setCoords(n4, n5, n6, n7);
                this.A(this.I);
                this.I.setCoords(n8, n9, n2, n3);
                this.A(this.I);
            }
            this.B(this.I);
        }
        Rectangle rectangle = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 1, 1);
        this.scrollRectToVisible(rectangle);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        switch (this.G) {
            case 0: {
                this.A(mouseEvent);
            }
        }
    }

    private void A(MouseEvent mouseEvent) {
        if (this.I != null) {
            int n2 = this.B(this.I, mouseEvent.getPoint());
            if (n2 != -1) {
                this.setCursor(RectangleRubberBand.F[n2]);
            } else if (this.A(this.I, mouseEvent.getPoint())) {
                this.setCursor(RectangleRubberBand.G);
            } else {
                this.setCursor(RectangleRubberBand.H);
            }
        }
    }

    private void E(MouseEvent mouseEvent) {
        Point point = this.screenToImage(mouseEvent.getPoint());
        this.setSelectedColor(new Color(this.K.getRGB(point.x, point.y)));
    }

    private void D(MouseEvent mouseEvent) {
        Point point;
        if (this.I != null) {
            int n2 = this.B(this.I, mouseEvent.getPoint());
            if (n2 != -1) {
                this.I.setHotAnchorId(n2);
                this.I.setStatus(1);
            } else if (this.A(this.I, mouseEvent.getPoint())) {
                this.I.setStatus(2);
                this.setCursor(RectangleRubberBand.D);
                point = this.imageToScreen(this.I.getLeftTop());
                this.J = new Point((int)((double)mouseEvent.getX() - point.getX()), (int)((double)mouseEvent.getY() - point.getY()));
            }
        }
        if (this.I == null || this.I.getStatus() == 0) {
            Point point2;
            if (this.I != null) {
                this.A(this.I);
            }
            if (this.isImagePoint(point = this.screenToImage(point2 = mouseEvent.getPoint()))) {
                this.I = this.A();
                this.I.setPoint0(point);
                this.I.setPoint1(this.I.getPoint0());
                this.I.setStatus(1);
                this.I.setHotAnchorId(4);
                this.A(this.I);
            }
        }
    }

    private RectangleRubberBand A() {
        CropRatioItem cropRatioItem;
        ImageView imageView;
        RectangleRubberBand rectangleRubberBand = new RectangleRubberBand();
        ImageConfig imageConfig = this.B.getImageConfig();
        if (imageConfig.getCropPerimeterMin() != null) {
            rectangleRubberBand.setPerimeterMin(new Integer(imageConfig.getCropPerimeterMin()));
        }
        if ((imageView = (ImageView)this.B.getMain().getView().getImageView()) != null && imageView.getToolbarView() != null && imageView.getToolbarView().getCropRatioCombo() != null && imageView.getToolbarView().getCropRatioCombo().isVisible() && (cropRatioItem = (CropRatioItem)imageView.getToolbarView().getCropRatioCombo().getSelectedItem()) != null && cropRatioItem.ratio != null) {
            rectangleRubberBand.setProportions(cropRatioItem.ratio);
        }
        if (imageConfig.getCropRatio() != null) {
            rectangleRubberBand.setProportions(new Double(imageConfig.getCropRatio()));
        }
        return rectangleRubberBand;
    }
}

