/*
 * Decompiled with CFR 0.152.
 */
package jmaster.jumploader.view.impl.file.tree;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;
import javax.swing.tree.TreePath;
import jmaster.jumploader.model.api.IModel;
import jmaster.jumploader.model.api.config.ViewConfig;
import jmaster.jumploader.model.api.file.IFileBrowser;
import jmaster.jumploader.model.api.file.IFileBrowserListener;
import jmaster.jumploader.view.impl.file.tree.FileTreeMenu;
import jmaster.jumploader.view.impl.file.tree.dnd.FileTreeTransferHandler;
import jmaster.util.B.C;
import jmaster.util.log.A;
import jmaster.util.log.B;
import jmaster.util.swing.filetree.FileTreeNode;

public class FileTree
extends jmaster.util.swing.filetree.FileTree
implements MouseListener,
ActionListener,
KeyListener,
FileFilter,
IFileBrowserListener {
    private static final long \u00e0 = 2742688657779462599L;
    protected A \u00df = B.getInstance().getLog(this.getClass());
    private IModel \u00de;
    private FileTreeMenu \u00dd;

    public FileTree(IModel iModel) {
        this.\u00de = iModel;
        C.D(this, "init");
    }

    public void init() {
        ViewConfig viewConfig = this.\u00de.getViewConfig();
        this.\u00dd = new FileTreeMenu();
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.\u00dd.getItemRefresh().addActionListener(this);
        this.\u00de.getFileBrowser().addListener(this);
        this.setDragEnabled(true);
        this.setTransferHandler(new FileTreeTransferHandler());
        File[] fileArray = ViewConfig.getFilesFromPropertyString(viewConfig.getFileTreeViewRootFiles());
        this.A(fileArray);
        this.getFileTreeCellRenderer().setRenderFileLength(viewConfig.isFileTreeViewShowFileLength());
        super.getFileTreeModel().setFileFilter(this);
        this.expandRow(0);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.A(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.A(mouseEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TreePath treePath;
        Object object;
        if (actionEvent.getSource().equals(this.\u00dd.getItemRefresh()) && (object = (treePath = this.getSelectionPath()).getLastPathComponent()) != null && object instanceof FileTreeNode) {
            this.refresh();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 116) {
            this.refresh();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void fileBrowserLocationChanged(IFileBrowser iFileBrowser) {
        this.navigateTo(iFileBrowser.getPath());
    }

    public void fileBrowserLocationFilesListed(IFileBrowser iFileBrowser) {
    }

    private void A(MouseEvent mouseEvent) {
        int n2;
        if (mouseEvent.isPopupTrigger() && (n2 = this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY())) != -1) {
            Object object;
            TreePath treePath = this.getPathForRow(n2);
            if (!this.isPathSelected(treePath)) {
                this.setSelectionPath(treePath);
            }
            if ((object = treePath.getLastPathComponent()) instanceof FileTreeNode) {
                this.\u00dd.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public boolean accept(File file) {
        boolean bl;
        ViewConfig viewConfig = this.\u00de.getViewConfig();
        boolean bl2 = bl = !file.isHidden() || viewConfig.isFileTreeViewShowHiddenFiles();
        if (bl && file.isFile()) {
            if (!viewConfig.isFileTreeViewShowFiles()) {
                bl = false;
            } else if (viewConfig.getFileNamePattern() != null && !Pattern.matches(viewConfig.getFileNamePattern(), file.getName())) {
                bl = false;
            }
        }
        return bl;
    }
}

