/*
 * Decompiled with CFR 0.152.
 */
package jmaster.jumploader.model.impl.upload;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jmaster.jumploader.app.ShutdownCleaner;
import jmaster.jumploader.model.api.IModel;
import jmaster.jumploader.model.api.config.UploaderConfig;
import jmaster.jumploader.model.api.upload.IUploadFile;
import jmaster.jumploader.model.api.upload.IUploader;
import jmaster.jumploader.model.impl.upload.C;
import jmaster.util.lang.MutableLong;
import jmaster.util.log.A;
import jmaster.util.log.B;

public class UploadFilePreprocessor
implements jmaster.jumploader.model.api.upload.B {
    protected A \u015f = B.getInstance().getLog(this.getClass());
    private IModel \u015e;

    public UploadFilePreprocessor(IModel iModel) {
        this.\u015e = iModel;
        iModel.getUploader().addListener(this);
    }

    public void uploaderFileAddFailed(IUploader iUploader, jmaster.jumploader.model.api.A.C c2) {
    }

    public void uploaderFileAdded(IUploader iUploader, IUploadFile iUploadFile) {
        UploaderConfig uploaderConfig = this.\u015e.getUploaderConfig();
        if (iUploadFile.isFile() && "zipOnAdd".equals(uploaderConfig.getCompressionMode())) {
            if (uploaderConfig.getSkipZippingFilesPattern() != null && Pattern.matches(uploaderConfig.getSkipZippingFilesPattern(), iUploadFile.getName())) {
                return;
            }
            jmaster.util.B.C.C(this, "zipFile", new Class[]{IUploader.class, C.class}, new Object[]{iUploader, iUploadFile});
        }
        if (iUploadFile.isDirectory() && uploaderConfig.isZipDirectoriesOnAdd()) {
            jmaster.util.B.C.C(this, "zipDirectory", new Class[]{IUploader.class, C.class}, new Object[]{iUploader, iUploadFile});
        }
    }

    public void uploaderFileAdditionEnabledChanged(IUploader iUploader) {
    }

    public void uploaderFileMoved(IUploader iUploader, IUploadFile iUploadFile, int n2) {
    }

    public void uploaderFileRemovalEnabledChanged(IUploader iUploader) {
    }

    public void uploaderFileRemoved(IUploader iUploader, IUploadFile iUploadFile) {
    }

    public void uploaderFileStatusChanged(IUploader iUploader, IUploadFile iUploadFile) {
    }

    public void uploaderFileUpdated(IUploader iUploader, IUploadFile iUploadFile) {
    }

    public void uploaderFilesReset(IUploader iUploader) {
    }

    public void uploaderStatusChanged(IUploader iUploader) {
    }

    public void uploaderUploadEnabledChanged(IUploader iUploader) {
    }

    public void uploaderFilePartitionUploaded(IUploader iUploader, IUploadFile iUploadFile) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void zipFile(IUploader iUploader, C c2) {
        this.\u015f.D("Preprocessing " + c2);
        try {
            this.\u015e.getUploader().updateFileStatus(c2, 4);
            long l2 = c2.getLength();
            File file = UploadFilePreprocessor.A(c2);
            c2.A(file, true);
            if (l2 > 0L) {
                c2.A(new Double((double)file.length() / (double)l2));
            }
            c2.A(c2.getName() + ".zip");
            c2.G(true);
        }
        catch (Exception exception) {
            this.\u015f.E(exception, exception);
        }
        finally {
            iUploader.updateFileStatus(c2, 0);
            this.\u015f.D("Preprocessing finished for " + c2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void zipDirectory(IUploader iUploader, C c2) {
        this.\u015f.D("Preprocessing " + c2);
        try {
            this.\u015e.getUploader().updateFileStatus(c2, 4);
            File file = File.createTempFile("jumploader", ".zip");
            ShutdownCleaner.getInstance().addFile(file);
            MutableLong mutableLong = new MutableLong();
            jmaster.util.E.A.A a2 = jmaster.util.E.A.B.B().A();
            a2.A(c2.getPath(), file.getAbsolutePath(), mutableLong);
            c2.A(file, true, true);
            if (mutableLong.getValue() > 0L) {
                c2.A(new Double((double)file.length() / (double)mutableLong.getValue()));
            }
            c2.A(c2.getName() + ".zip");
            c2.G(true);
            c2.getAttributeSet().setStringAttribute("zippedDirectory", "true");
        }
        catch (Exception exception) {
            this.\u015f.E(exception, exception);
        }
        finally {
            iUploader.updateFileStatus(c2, 0);
            this.\u015f.D("Preprocessing finished for " + c2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File A(IUploadFile iUploadFile) throws Exception {
        File file = null;
        File file2 = File.createTempFile("jumploader_", ".zip");
        ShutdownCleaner.getInstance().addFile(file2);
        file2.deleteOnExit();
        BufferedOutputStream bufferedOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            zipOutputStream = new ZipOutputStream(bufferedOutputStream);
            bufferedInputStream = new BufferedInputStream(new FileInputStream(iUploadFile.getFile()));
            ZipEntry zipEntry = new ZipEntry(iUploadFile.getName());
            zipEntry.setSize(iUploadFile.getLength());
            zipOutputStream.putNextEntry(zipEntry);
            jmaster.util.E.A.A(bufferedInputStream, zipOutputStream);
            zipOutputStream.closeEntry();
        }
        catch (Throwable throwable) {
            jmaster.util.E.A.A(zipOutputStream);
            jmaster.util.E.A.A(bufferedOutputStream);
            jmaster.util.E.A.A(bufferedInputStream);
            throw throwable;
        }
        jmaster.util.E.A.A(zipOutputStream);
        jmaster.util.E.A.A(bufferedOutputStream);
        jmaster.util.E.A.A(bufferedInputStream);
        file = file2;
        return file;
    }

    public void destroy() {
    }
}

