/*
 * Decompiled with CFR 0.152.
 */
package jmaster.draw.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.Transparency;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmaster.draw.view.PaletteFactoryParam;
import jmaster.swing.A.A;
import jmaster.util.lang.bean.IBeanFactory;
import jmaster.util.lang.bean.impl.GenericBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaletteFactory
extends GenericBeanFactory {
    private static final long \u01fd = -8627077398917808464L;
    static final Color[] \u01fc = new Color[]{Color.red, Color.yellow, Color.green, Color.cyan, Color.blue, Color.magenta};

    public BufferedImage createBasicColorGradientImage(int n2, int n3) {
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        int n4 = \u01fc.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            GradientPaint gradientPaint = new GradientPaint(i2 * n2 / n4, 0.0f, \u01fc[i2 % n4], (i2 + 1) * n2 / n4, 0.0f, \u01fc[(i2 + 1) % n4]);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(i2 * n2 / n4, 0, n2 / n4, n3);
        }
        return bufferedImage;
    }

    public Container createBitmapColorPalette(Container container, IBeanFactory<JLabel> iBeanFactory, ImageIcon imageIcon, String string, int n2, int n3) {
        Image image = imageIcon.getImage();
        BufferedImage bufferedImage = null;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else {
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.drawImage(image, 0, 0, null);
        }
        int n4 = bufferedImage.getHeight();
        int n5 = bufferedImage.getWidth();
        Color[] colorArray = new Color[n4 * n5];
        for (int i2 = 0; i2 < n4; ++i2) {
            for (int i3 = 0; i3 < n5; ++i3) {
                colorArray[i3 + i2 * n5] = new Color(bufferedImage.getRGB(i3, i2));
            }
        }
        return this.createColorPalette(container, iBeanFactory, string, colorArray, n2, n3);
    }

    public Container createColorPalette(Container container, IBeanFactory<JLabel> iBeanFactory, String string, Color[] colorArray, int n2, int n3) {
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            Color color = colorArray[i2];
            Icon icon = this.createColorIcon(n2, n3, color);
            JLabel jLabel = iBeanFactory.createBean();
            jLabel.putClientProperty(string, color);
            jLabel.setIcon(icon);
            container.add(jLabel);
        }
        return container;
    }

    public Container createBasicColorPalette(Container container, IBeanFactory<JLabel> iBeanFactory, boolean bl, int n2, int n3, int n4) {
        Transparency transparency;
        int n5 = n3 + n4 + 1;
        int n6 = n2 + (bl ? 1 : 0);
        if (container == null) {
            container = new JPanel();
            container.setLayout(new GridLayout(n5, n6));
        }
        BufferedImage bufferedImage = null;
        if (bl) {
            bufferedImage = new BufferedImage(1, n5, 1);
            transparency = new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, n5, Color.black);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setPaint((Paint)transparency);
            graphics2D.fillRect(0, 0, 1, n5);
        }
        transparency = this.createBasicColorGradientImage(n2, 1);
        for (int i2 = 0; i2 < n5; ++i2) {
            int n7 = n5 - n3 - 1 - i2;
            int n8 = n5 - n4 * 2 - n3 - 1 + i2;
            for (int i3 = 0; i3 < n6; ++i3) {
                Color color = null;
                if (i3 == 0 && bl) {
                    color = new Color(bufferedImage.getRGB(0, i2));
                } else {
                    int n9;
                    color = new Color(((BufferedImage)transparency).getRGB(i3 - (bl ? 1 : 0), 0));
                    for (n9 = 0; n9 < n7; ++n9) {
                        color = color.brighter();
                    }
                    for (n9 = 0; n9 < n8; ++n9) {
                        color = color.darker();
                    }
                }
                Component component = iBeanFactory.createBean();
                component.setBackground(color);
                container.add(component);
            }
        }
        return container;
    }

    public Container createStrokePalette(Container container, IBeanFactory<JLabel> iBeanFactory, List<Stroke> list, String string, int n2, int n3, Color color, Color color2) {
        for (Stroke stroke : list) {
            Icon icon = this.createStrokeIcon(n2, n3, stroke, color, color2);
            JLabel jLabel = iBeanFactory.createBean();
            jLabel.setIcon(icon);
            jLabel.putClientProperty(string, stroke);
            container.add(jLabel);
        }
        return container;
    }

    public Icon createStrokeIcon(int n2, int n3, Stroke stroke, Color color, Color color2) {
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(color2);
        graphics2D.fillRect(0, 0, n2, n3);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
        Line2D.Double double_ = new Line2D.Double(0.0, n3 / 2, n2, n3 / 2);
        graphics2D.draw(double_);
        return new ImageIcon(bufferedImage);
    }

    public Icon createColorIcon(int n2, int n3, Color color) {
        A a2 = new A();
        a2.A(n2, n3);
        a2.A(color);
        return a2;
    }

    @Override
    public Object createBeanInternal(Object object) throws Exception {
        Icon icon = null;
        PaletteFactoryParam paletteFactoryParam = (PaletteFactoryParam)object;
        if ("stroke".equals(paletteFactoryParam.getDrawingPropertyId())) {
            icon = this.createStrokeIcon(paletteFactoryParam.getIconWidth(), paletteFactoryParam.getIconHeight(), (Stroke)paletteFactoryParam.getDrawingPropertyValue(), paletteFactoryParam.getForeground(), paletteFactoryParam.getBackground());
        } else if ("foregroundColor".equals(paletteFactoryParam.getDrawingPropertyId()) || "backgroundColor".equals(paletteFactoryParam.getDrawingPropertyId())) {
            icon = this.createColorIcon(paletteFactoryParam.getIconWidth(), paletteFactoryParam.getIconHeight(), (Color)paletteFactoryParam.getDrawingPropertyValue());
        } else {
            throw new RuntimeException("Cannot create icon for drawing property id=" + paletteFactoryParam.getDrawingPropertyId());
        }
        return icon;
    }

    public List<Stroke> createBasicStrokeList(String string, String string2, String string3) {
        ArrayList<Stroke> arrayList = new ArrayList<Stroke>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
        StringTokenizer stringTokenizer3 = new StringTokenizer(string3, ",");
        int n2 = 0;
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            int n4 = Integer.parseInt(stringTokenizer.nextToken().trim());
            if (stringTokenizer2.hasMoreTokens()) {
                n2 = Integer.parseInt(stringTokenizer2.nextToken().trim());
            }
            if (stringTokenizer3.hasMoreTokens()) {
                n3 = Integer.parseInt(stringTokenizer3.nextToken().trim());
            }
            BasicStroke basicStroke = new BasicStroke(n4, n2, n3);
            arrayList.add(basicStroke);
        }
        return arrayList;
    }
}

