/*
 * Decompiled with CFR 0.152.
 */
package jmaster.draw.impl;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import jmaster.C.A;
import jmaster.draw.B;
import jmaster.draw.C;
import jmaster.draw.D;
import jmaster.draw.F;
import jmaster.draw.G;
import jmaster.draw.H;
import jmaster.draw.J;
import jmaster.draw.K;
import jmaster.draw.impl.GeomHelper;
import jmaster.util.lang.LangHelper;
import jmaster.util.lang.bean.impl.GenericBean;
import jmaster.util.lang.list.IList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawingContext
extends GenericBean
implements B {
    protected GeomHelper \u03a8;
    protected C \u03ad;
    protected boolean \u03a5 = true;
    protected double \u03b1 = 1.0;
    protected double \u03a6 = 0.01;
    protected double \u03ae = 100.0;
    protected Rectangle2D \u03aa;
    protected AffineTransform \u03a3;
    protected List<J> \u03ab = new ArrayList<J>();
    protected F \u03af;
    protected D \u03a7;
    protected K \u03a9;
    protected Cursor \u03b0 = Cursor.getDefaultCursor();
    protected IList<H> \u03a4;
    protected G \u03a1;
    protected IList<K> \u03ac;

    @Override
    public C getDrawing() {
        return this.\u03ad;
    }

    public void setDrawing(C c2) {
        this.\u03ad = c2;
    }

    @Override
    public double getZoom() {
        return this.\u03b1;
    }

    public void setZoom(double d2) {
        this.\u03b1 = d2;
        this.\u03a3 = null;
    }

    public double getZoomMin() {
        return this.\u03a6;
    }

    public void setZoomMin(double d2) {
        this.\u03a6 = d2;
    }

    public double getZoomMax() {
        return this.\u03ae;
    }

    public void setZoomMax(double d2) {
        this.\u03ae = d2;
    }

    @Override
    public Rectangle2D getViewport() {
        return this.\u03aa;
    }

    @Override
    public void setViewport(Rectangle2D rectangle2D) {
        this.\u03aa = rectangle2D;
        this.\u03a3 = null;
        this.\u03ad.setViewport(rectangle2D);
        this.C(EVENT_PROPERTY_CHANGED, "viewport", rectangle2D);
    }

    @Override
    public AffineTransform getViewTransform() {
        if (this.\u03a3 == null) {
            this.\u03a3 = new AffineTransform();
            this.\u03a3.scale(this.\u03b1, this.\u03b1);
            if (this.\u03aa != null) {
                this.\u03a3.translate(-this.\u03aa.getX(), -this.\u03aa.getY());
            }
        }
        return this.\u03a3;
    }

    @Override
    public boolean isAntialiasing() {
        return this.\u03a5;
    }

    @Override
    public void setAntialiasing(boolean bl) {
        if (this.\u03a5 ^ bl) {
            this.\u03a5 = bl;
            this.C(EVENT_PROPERTY_CHANGED, "antialiasing", bl);
        }
    }

    @Override
    public F getLastMouseAction() {
        return this.\u03af;
    }

    @Override
    public D getLastKeyAction() {
        return this.\u03a7;
    }

    public void setLastKeyAction(D d2) {
        this.\u03a7 = d2;
        this.C(EVENT_PROPERTY_CHANGED, "lastKeyAction", d2);
    }

    @Override
    public K getTool() {
        return this.\u03a9;
    }

    @Override
    public void setTool(K k2) {
        if (!LangHelper.equals(k2, this.\u03a9)) {
            if (this.\u03a9 != null) {
                this.\u03a9.passivate();
                this.C(EVENT_TOOL_PASSIVATED, this.\u03a9);
            }
            this.\u03a9 = k2;
            if (this.\u03a9 != null) {
                this.\u03a9.activate(this);
                this.C(EVENT_TOOL_ACTIVATED, this.\u03a9);
                this.C(EVENT_PROPERTY_CHANGED, "tool", this.\u03a9);
            }
        }
    }

    @Override
    public Cursor getCursor() {
        return this.\u03b0;
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (!LangHelper.equals(this.\u03b0, cursor)) {
            this.\u03b0 = cursor;
            this.C(EVENT_PROPERTY_CHANGED, "cursor", this.\u03b0);
        }
    }

    public GeomHelper getGeomHelper() {
        return this.\u03a8;
    }

    public void setGeomHelper(GeomHelper geomHelper) {
        this.\u03a8 = geomHelper;
    }

    @Override
    public IList<H> getDrawingControls() {
        return this.\u03a4;
    }

    public void setDrawingControls(IList<H> iList) {
        this.\u03a4 = iList;
    }

    @Override
    public G getMouseOwner() {
        return this.\u03a1;
    }

    @Override
    public void setMouseOwner(G g2) {
        if (g2 != null && this.\u03a1 != null) {
            LangHelper.throwRuntime("Can not set new mouse owner (" + g2 + ") because already set(" + this.\u03a1 + ")");
        }
        this.\u03a1 = g2;
        if (this.\u0217.B()) {
            this.\u0217.D("Mouse owner changed:" + g2);
        }
        this.C(EVENT_PROPERTY_CHANGED, "mouseOwner", g2);
    }

    @Override
    public IList<K> getDrawingTools() {
        return this.\u03ac;
    }

    public void setDrawingTools(IList<K> iList) {
        this.\u03ac = iList;
    }

    @Override
    public void handleMouseEvent(MouseEvent mouseEvent) {
        F f2 = new F();
        f2.A(this);
        f2.A(mouseEvent);
        f2.A(this.\u03af);
        if (this.\u03af != null) {
            this.\u03af.A((F)null);
        }
        if (this.\u03a1 != null) {
            this.\u03a1.handleMouseAction(f2);
        } else {
            if (this.\u03a9 != null) {
                this.\u03a9.handleMouseAction(f2);
            }
            for (H h2 : this.\u03a4) {
                h2.handleMouseAction(f2);
            }
        }
        this.\u03af = f2;
        this.C(EVENT_PROPERTY_CHANGED, "lastMouseAction", this.\u03af);
    }

    @Override
    public void handleKeyEvent(KeyEvent keyEvent) {
        D d2 = new D();
        d2.A(keyEvent);
        if (this.\u03a9 != null) {
            this.\u03a9.handleKeyAction(d2);
        }
        for (H h2 : this.\u03a4) {
            h2.handleKeyAction(d2);
        }
        this.setLastKeyAction(d2);
    }

    @Override
    public void init() {
        super.init();
        System.setProperty("sun.java2d.d3d", "false");
        this.changeZoom(this.\u03b1, null);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    protected A C(Graphics2D graphics2D) {
        A a2 = new A(graphics2D);
        if (this.isAntialiasing()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        return a2;
    }

    protected void A(A a2, J j2) {
        for (int i2 = this.\u03ad.getElementCount(j2) - 1; i2 >= 0; --i2) {
            J j3 = (J)this.\u03ad.get(j2, i2);
            this.A(a2, j3);
        }
        if (j2 != null) {
            j2.render(a2);
            a2.B();
        }
    }

    @Override
    public double getWidth() {
        return this.\u03aa == null ? -1.0 : this.\u03aa.getWidth();
    }

    @Override
    public double getHeight() {
        return this.\u03aa == null ? -1.0 : this.\u03aa.getHeight();
    }

    @Override
    public boolean isSelected(J j2) {
        return this.\u03ab.contains(j2);
    }

    @Override
    public void setSelected(J j2, boolean bl) {
        if (this.isSelected(j2) ^ bl) {
            if (bl) {
                this.\u03ab.add(j2);
            } else {
                this.\u03ab.remove(j2);
            }
            this.C(EVENT_OBJECT_SELECTED_CHANGED, j2, bl);
        }
    }

    @Override
    public void clearSelection() {
        if (this.\u03ab.size() > 0) {
            this.\u03ab.clear();
            this.M(EVENT_OBJECT_SELECTION_CLEARED);
        }
    }

    @Override
    public J getSelected(int n2) {
        return this.\u03ab.get(n2);
    }

    @Override
    public int getSelectedCount() {
        return this.\u03ab.size();
    }

    @Override
    public boolean hasSelected() {
        return this.\u03ab.size() > 0;
    }

    @Override
    public void changeZoom(double d2, Point2D point2D) {
        if (d2 < this.\u03a6) {
            d2 = this.\u03a6;
        }
        if (d2 > this.\u03ae) {
            d2 = this.\u03ae;
        }
        if (this.\u03b1 != d2 || this.\u03a3 == null) {
            this.\u03b1 = d2;
            this.\u03a3 = null;
            this.C(EVENT_ZOOM_CHANGED, d2, point2D);
        }
    }

    @Override
    public boolean canZoomIn() {
        return this.\u03b1 < this.\u03ae;
    }

    @Override
    public boolean canZoomOut() {
        return this.\u03b1 > this.\u03a6;
    }

    @Override
    public void changeZoomTicks(int n2, Point2D point2D) {
        double d2 = this.getZoom() + (double)n2 * this.getZoom() / 10.0;
        this.changeZoom(d2, point2D);
    }

    @Override
    public Point2D getDrawingPoint(Point2D point2D, Point2D point2D2) {
        try {
            return this.getViewTransform().inverseTransform(point2D, point2D2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            LangHelper.handleRuntime(noninvertibleTransformException);
            return null;
        }
    }

    @Override
    public Point2D getDrawingPoint(Point2D point2D) {
        return this.getDrawingPoint(point2D, null);
    }

    @Override
    public Point2D getViewPoint(Point2D point2D, Point2D point2D2) {
        return this.\u03a3.transform(point2D, point2D2);
    }

    @Override
    public Point2D getViewPoint(Point2D point2D) {
        return this.getViewPoint(point2D, null);
    }

    @Override
    public Rectangle2D getDrawingRectangle(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        try {
            double[] dArray = new double[]{rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight()};
            double[] dArray2 = new double[dArray.length];
            this.\u03a3.inverseTransform(dArray, 0, dArray2, 0, dArray.length / 2);
            if (rectangle2D2 == null) {
                rectangle2D2 = new Rectangle2D.Double();
            }
            rectangle2D2.setFrame(dArray2[0], dArray2[1], dArray2[2] - dArray2[0], dArray2[3] - dArray2[1]);
            return rectangle2D2;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            LangHelper.handleRuntime(noninvertibleTransformException);
            return null;
        }
    }

    @Override
    public Rectangle2D getDrawingRectangle(Rectangle2D rectangle2D) {
        return this.getDrawingRectangle(rectangle2D, null);
    }

    @Override
    public Rectangle2D getViewRectangle(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double[] dArray = new double[]{rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight()};
        double[] dArray2 = new double[dArray.length];
        this.\u03a3.transform(dArray, 0, dArray2, 0, dArray.length / 2);
        if (rectangle2D2 == null) {
            rectangle2D2 = new Rectangle2D.Double();
        }
        rectangle2D2.setFrame(dArray2[0], dArray2[1], dArray2[2] - dArray2[0], dArray2[3] - dArray2[1]);
        return rectangle2D2;
    }

    @Override
    public Rectangle2D getViewRectangle(Rectangle2D rectangle2D) {
        return this.getViewRectangle(rectangle2D, null);
    }

    @Override
    public Rectangle2D getSelectionBounds() {
        Rectangle2D rectangle2D = null;
        for (int i2 = 0; i2 < this.getSelectedCount(); ++i2) {
            J j2 = this.getSelected(i2);
            if (rectangle2D == null) {
                rectangle2D = (Rectangle2D)j2.getBounds().clone();
                continue;
            }
            rectangle2D.add(j2.getBounds());
        }
        return rectangle2D;
    }

    @Override
    public void renderDrawingControls(Graphics2D graphics2D) {
        A a2 = this.C(graphics2D);
        for (H h2 : this.\u03a4) {
            h2.render(a2);
            a2.B();
        }
        if (this.\u03a9 != null) {
            this.\u03a9.render(a2);
            a2.B();
        }
    }

    @Override
    public void renderDrawing(Graphics2D graphics2D) {
        this.renderDrawing(graphics2D, null);
    }

    @Override
    public void renderDrawing(Graphics2D graphics2D, J j2) {
        A a2 = this.C(graphics2D);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.transform(this.getViewTransform());
        this.A(a2, j2);
        a2.B();
        graphics2D.setTransform(affineTransform);
    }

    @Override
    public void repaint(Rectangle2D rectangle2D) {
        Rectangle rectangle = rectangle2D == null ? null : this.getViewTransform().createTransformedShape(rectangle2D).getBounds();
        this.C(EVENT_REPAINT_REQUEST, rectangle2D, rectangle);
    }

    @Override
    public BufferedImage renderToBufferedImage() {
        Rectangle2D rectangle2D = this.getViewport();
        BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        A a2 = this.C(graphics2D);
        a2.translate(-rectangle2D.getX(), -rectangle2D.getY());
        this.A(a2, null);
        return bufferedImage;
    }
}

